/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.expand;

import com.atlassian.plugins.rest.common.expand.Expandable;
import com.atlassian.plugins.rest.common.expand.entity.ListWrapper;
import com.atlassian.plugins.rest.common.expand.entity.ListWrapperCallback;
import com.atlassian.plugins.rest.common.expand.parameter.Indexes;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;

public abstract class PagedListWrapper<T, Z>
implements ListWrapper<T> {
    @XmlAttribute
    protected int size;
    @XmlAttribute(name="max-results")
    private final int maxResults;
    @XmlAttribute(name="start-index")
    protected int startIndex;
    @XmlAttribute(name="end-index")
    protected int endIndex;
    @XmlAttribute(name="items")
    @Expandable
    private final Collection<T> items = Lists.newArrayList();

    private PagedListWrapper() {
        this.size = 0;
        this.maxResults = 0;
        this.startIndex = 0;
        this.endIndex = 0;
    }

    public PagedListWrapper(int size, int maxResults) {
        this.size = size;
        this.maxResults = maxResults;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public final ListWrapperCallback<T> getCallback() {
        return new ListWrapperCallback<T>(){

            public List<T> getItems(Indexes indexes) {
                return PagedListWrapper.this.getPagingCallback().getItems(indexes);
            }
        };
    }

    public ListWrapperCallback<T> getPagingCallback() {
        return new ListWrapperCallback<T>(){
            final List<T> pagedBeans = Lists.newArrayList();

            public List<T> getItems(Indexes indexes) {
                PagedListWrapper.this.size = PagedListWrapper.this.getBackingListSize();
                if (PagedListWrapper.this.size > 0) {
                    PagedListWrapper.this.startIndex = indexes.getMinIndex(PagedListWrapper.this.getSize());
                    if (PagedListWrapper.this.startIndex >= 0) {
                        PagedListWrapper.this.endIndex = indexes.getMaxIndex(PagedListWrapper.this.getSize());
                        PagedListWrapper.this.endIndex = PagedListWrapper.this.endIndex > PagedListWrapper.this.getMaxResults() ? PagedListWrapper.this.getMaxResults() : PagedListWrapper.this.endIndex;
                        List sortedBackingObjects = PagedListWrapper.this.getOrderedList(PagedListWrapper.this.startIndex, PagedListWrapper.this.endIndex);
                        for (Object backingObject : sortedBackingObjects) {
                            this.pagedBeans.add(PagedListWrapper.this.fromBackedObject(backingObject));
                        }
                    }
                }
                return this.pagedBeans;
            }
        };
    }

    public abstract T fromBackedObject(Z var1);

    public abstract int getBackingListSize();

    public abstract List<Z> getOrderedList(int var1, int var2);
}

