/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.issue;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public class NullRespectingJSONSerializer
extends JsonSerializer<Object> {
    public void serialize(Object object, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Preconditions.checkNotNull((Object)object, (Object)"The object to serialize to JSON should not be a null reference according to Jackson.");
        jgen.writeStartObject();
        for (Field field : object.getClass().getFields()) {
            JsonProperty jsonAnnotation = field.getAnnotation(JsonProperty.class);
            if (!NullRespectingJSONSerializer.isPublic(field) && jsonAnnotation == null) continue;
            try {
                String jsonName;
                Object fieldValue = field.get(object);
                String overrideName = jsonAnnotation != null ? jsonAnnotation.value() : null;
                String string = jsonName = !StringUtils.isEmpty((String)overrideName) ? overrideName : field.getName();
                if (fieldValue != null) {
                    provider.defaultSerializeField(jsonName, fieldValue, jgen);
                    continue;
                }
                jgen.writeNullField(jsonName);
            }
            catch (IllegalAccessException e) {
                throw new JsonGenerationException("Error reading field '" + field.getName() + "'", (Throwable)e);
            }
        }
        jgen.writeEndObject();
    }

    protected static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }
}

