/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.issue;

import com.atlassian.jira.rest.api.issue.FieldsSerializer;
import com.atlassian.jira.rest.api.issue.ResourceId;
import com.atlassian.jira.rest.api.issue.TimeTracking;
import com.atlassian.jira.rest.api.issue.UserId;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=FieldsSerializer.class)
public class IssueFields {
    private static final Logger log = LoggerFactory.getLogger(IssueFields.class);
    private static final String CUSTOMFIELD_ = "customfield_";
    public ResourceId parent;
    public ResourceId project;
    public String summary;
    @JsonProperty(value="issuetype")
    public ResourceId issueType;
    public UserId assignee;
    public UserId reporter;
    public ResourceId priority;
    public List<String> labels;
    public TimeTracking timeTracking;
    public ResourceId securityLevel;
    public List<ResourceId> versions;
    public String environment;
    public String description;
    public String dueDate;
    public List<ResourceId> fixVersions;
    public List<ResourceId> components;
    Map<String, String[]> fields;

    public ResourceId parent() {
        return this.parent;
    }

    public IssueFields parent(ResourceId parent) {
        this.parent = parent;
        return this;
    }

    public ResourceId project() {
        return this.project;
    }

    public IssueFields project(ResourceId project) {
        this.project = project;
        return this;
    }

    public String summary() {
        return this.summary;
    }

    public IssueFields summary(String summary) {
        this.summary = summary;
        return this;
    }

    public ResourceId issueType() {
        return this.issueType;
    }

    public IssueFields issueType(ResourceId issueType) {
        this.issueType = issueType;
        return this;
    }

    public UserId assignee() {
        return this.assignee;
    }

    public IssueFields assignee(UserId assignee) {
        this.assignee = assignee;
        return this;
    }

    public UserId reporter() {
        return this.reporter;
    }

    public IssueFields reporter(UserId reporter) {
        this.reporter = reporter;
        return this;
    }

    public ResourceId priority() {
        return this.priority;
    }

    public IssueFields priority(ResourceId priority) {
        this.priority = priority;
        return this;
    }

    public List<String> labels() {
        return this.labels;
    }

    public IssueFields labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public TimeTracking timeTracking() {
        return this.timeTracking;
    }

    public IssueFields timeTracking(TimeTracking timeTracking) {
        this.timeTracking = timeTracking;
        return this;
    }

    public ResourceId securityLevel() {
        return this.securityLevel;
    }

    public IssueFields securityLevel(ResourceId securityLevel) {
        this.securityLevel = securityLevel;
        return this;
    }

    public List<ResourceId> versions() {
        return this.versions;
    }

    public IssueFields versions(List<ResourceId> affectsVersions) {
        this.versions = affectsVersions;
        return this;
    }

    public IssueFields versions(ResourceId ... affectsVersions) {
        this.versions = affectsVersions != null ? Arrays.asList(affectsVersions) : null;
        return this;
    }

    public String environment() {
        return this.environment;
    }

    public IssueFields environment(String environment) {
        this.environment = environment;
        return this;
    }

    public String description() {
        return this.description;
    }

    public IssueFields description(String description) {
        this.description = description;
        return this;
    }

    public String dueDate() {
        return this.dueDate;
    }

    public IssueFields dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public List<ResourceId> fixVersions() {
        return this.fixVersions;
    }

    public IssueFields fixVersions(List<ResourceId> fixVersions) {
        this.fixVersions = fixVersions;
        return this;
    }

    public IssueFields fixVersions(ResourceId ... fixVersions) {
        this.fixVersions = fixVersions != null ? Arrays.asList(fixVersions) : null;
        return this;
    }

    public List<ResourceId> components() {
        return this.components;
    }

    public IssueFields components(List<ResourceId> components) {
        this.components = components;
        return this;
    }

    public IssueFields components(ResourceId ... component) {
        this.components = component != null ? Arrays.asList(component) : null;
        return this;
    }

    public String[] customField(Long customFieldId) {
        return this.fields != null ? this.fields.get(CUSTOMFIELD_ + customFieldId) : null;
    }

    public IssueFields customField(Long customFieldId, String ... value) {
        if (this.fields == null) {
            this.fields = Maps.newHashMap();
        }
        this.fields.put(CUSTOMFIELD_ + customFieldId, value);
        return this;
    }

    public Map<Long, String[]> customFields() {
        if (this.fields == null) {
            return Collections.emptyMap();
        }
        HashMap customFieldById = Maps.newHashMapWithExpectedSize((int)this.fields.size());
        for (Map.Entry<String, String[]> field : this.fields.entrySet()) {
            String key = field.getKey();
            String[] value = field.getValue();
            if (!key.startsWith(CUSTOMFIELD_)) continue;
            customFieldById.put(Long.valueOf(key.substring(CUSTOMFIELD_.length())), value);
        }
        return customFieldById;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @JsonAnySetter
    protected void customField(String fieldId, Object value) {
        if (!fieldId.startsWith(CUSTOMFIELD_)) {
            log.debug("Field '{}' is not known, ignoring.", (Object)fieldId);
            return;
        }
        if (!(value instanceof List)) {
            log.debug("Field '{}' does not contain an array of strings, ignoring.", (Object)fieldId);
            return;
        }
        List strings = (List)value;
        if (this.fields == null) {
            this.fields = Maps.newHashMap();
        }
        this.fields.put(fieldId, strings.toArray(new String[strings.size()]));
    }
}

