/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.util;

import com.atlassian.jira.rest.api.util.ValidationError;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@XmlRootElement
public class ErrorCollection {
    @XmlElement
    private Collection<String> errorMessages = new ArrayList<String>();
    @XmlElement
    private Map<String, String> errors = new HashMap<String, String>();
    private Response.Status status;

    public static Builder builder() {
        return Builder.newBuilder();
    }

    public static ErrorCollection of(String ... messages) {
        return ErrorCollection.of(Arrays.asList(messages));
    }

    public static ErrorCollection of(Iterable<String> messages) {
        Builder b = ErrorCollection.builder();
        for (String message : messages) {
            b.addErrorMessage(message);
        }
        return b.build();
    }

    public static ErrorCollection of(com.atlassian.jira.util.ErrorCollection errorCollection) {
        return ErrorCollection.builder().addErrorCollection(errorCollection).build();
    }

    private ErrorCollection() {
    }

    private ErrorCollection(Collection<String> errorMessages) {
        this.errorMessages.addAll((Collection)Assertions.notNull((String)"errorMessages", errorMessages));
    }

    private void addErrorCollection(com.atlassian.jira.util.ErrorCollection errorCollection) {
        this.errorMessages.addAll(((com.atlassian.jira.util.ErrorCollection)Assertions.notNull((String)"errorCollection", (Object)errorCollection)).getErrorMessages());
        this.errors.putAll(errorCollection.getErrors());
        this.reason(ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons()));
    }

    private void addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    public boolean hasAnyErrors() {
        return !this.errorMessages.isEmpty() && !this.errors.isEmpty();
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public ErrorCollection reason(ErrorCollection.Reason reason) {
        this.status = ErrorCollection.getStatusFromReason(reason);
        return this;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static Response.Status getStatusFromReason(ErrorCollection.Reason reason) {
        if (reason == null) {
            return Response.Status.BAD_REQUEST;
        }
        switch (reason) {
            case NOT_FOUND: {
                return Response.Status.NOT_FOUND;
            }
            case NOT_LOGGED_IN: {
                return Response.Status.UNAUTHORIZED;
            }
            case FORBIDDEN: {
                return Response.Status.FORBIDDEN;
            }
            case VALIDATION_FAILED: {
                return Response.Status.BAD_REQUEST;
            }
            case SERVER_ERROR: {
                return Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    public static class Builder {
        private ErrorCollection errorCollection;

        public static Builder newBuilder() {
            return new Builder(Collections.<String>emptyList());
        }

        public static Builder newBuilder(ValidationError ... errors) {
            Assertions.notNull((String)"errors", (Object)errors);
            return new Builder(Collections.<String>emptyList());
        }

        public static Builder newBuilder(Set<String> errorMessages) {
            Assertions.notNull((String)"errorMessages", errorMessages);
            return new Builder(errorMessages);
        }

        public static Builder newBuilder(Collection<ValidationError> errors) {
            Assertions.notNull((String)"errors", errors);
            return new Builder(Collections.<String>emptyList());
        }

        public static Builder newBuilder(ErrorCollection errorCollection) {
            Assertions.notNull((String)"errorCollection", (Object)errorCollection);
            return new Builder(errorCollection.getErrorMessages());
        }

        Builder(Collection<String> errorMessages) {
            this.errorCollection = new ErrorCollection(errorMessages);
        }

        public Builder addErrorCollection(com.atlassian.jira.util.ErrorCollection errorCollection) {
            Assertions.notNull((String)"errorCollection", (Object)errorCollection);
            this.errorCollection.addErrorCollection(errorCollection);
            return this;
        }

        public Builder addErrorMessage(String errorMessage) {
            Assertions.notNull((String)"errorMessage", (Object)errorMessage);
            this.errorCollection.addErrorMessage(errorMessage);
            return this;
        }

        public ErrorCollection build() {
            return this.errorCollection;
        }
    }
}

