/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.field;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="field")
public class FieldBean<T> {
    @XmlElement(name="name")
    private final String name;
    @XmlElement(name="type")
    private final String type;
    @XmlElement(name="value")
    private final T value;

    public static <T> FieldBean<T> create(String name, String type, T value) {
        return new FieldBean<T>(name, type, value);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public FieldBean(String name, String type, T value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldBean fieldBean = (FieldBean)o;
        return this.name.equals(fieldBean.name) && this.type.equals(fieldBean.type) && !(this.value == null ? fieldBean.value != null : !this.value.equals(fieldBean.value));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FieldBean{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", value=" + this.value + '}';
    }

    public static class Builder<T> {
        private String name;
        private String type;
        private T value;

        Builder() {
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> type(String type) {
            this.type = type;
            return this;
        }

        public Builder<T> value(T value) {
            this.value = value;
            return this;
        }

        public FieldBean<T> build() {
            return FieldBean.create(this.name, this.type, this.value);
        }
    }
}

