/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.util;

import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@XmlRootElement
public class ErrorCollection {
    @XmlElement
    private Collection<String> errorMessages = Lists.newArrayList();
    @XmlElement
    private Map<String, String> errors = Maps.newHashMap();
    private Response.Status status;

    public static ErrorCollection of(String ... messages) {
        return ErrorCollection.of(Arrays.asList(messages));
    }

    public static ErrorCollection of(Collection<String> messages) {
        return new ErrorCollection().addErrorMessages(messages);
    }

    public static ErrorCollection of(com.atlassian.jira.util.ErrorCollection errorCollection) {
        return new ErrorCollection().addErrorCollection(errorCollection);
    }

    public ErrorCollection addErrorCollection(com.atlassian.jira.util.ErrorCollection errorCollection) {
        this.errorMessages.addAll(((com.atlassian.jira.util.ErrorCollection)Preconditions.checkNotNull((Object)errorCollection)).getErrorMessages());
        this.errors.putAll(errorCollection.getErrors());
        this.reason(ErrorCollection.Reason.getWorstReason((Collection)errorCollection.getReasons()));
        return this;
    }

    public ErrorCollection addErrorMessage(String errorMessage) {
        this.errorMessages.add((String)Preconditions.checkNotNull((Object)errorMessage));
        return this;
    }

    public ErrorCollection addErrorMessages(Collection<String> messages) {
        this.errorMessages.addAll((Collection)Preconditions.checkNotNull(messages));
        return this;
    }

    public boolean hasAnyErrors() {
        return !this.errorMessages.isEmpty() || !this.errors.isEmpty();
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public ErrorCollection reason(ErrorCollection.Reason reason) {
        this.status = ErrorCollection.getStatusFromReason(reason);
        return this;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static Response.Status getStatusFromReason(ErrorCollection.Reason reason) {
        if (reason == null) {
            return Response.Status.BAD_REQUEST;
        }
        switch (reason) {
            case NOT_FOUND: {
                return Response.Status.NOT_FOUND;
            }
            case NOT_LOGGED_IN: {
                return Response.Status.UNAUTHORIZED;
            }
            case FORBIDDEN: {
                return Response.Status.FORBIDDEN;
            }
            case VALIDATION_FAILED: {
                return Response.Status.BAD_REQUEST;
            }
            case SERVER_ERROR: {
                return Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.Status.BAD_REQUEST;
    }
}

