/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.quickedit.rest.api.UserPreferences;
import com.atlassian.jira.quickedit.user.UserPreferencesStore;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UserPreferencesStoreImpl
implements UserPreferencesStore {
    private static final List<String> EDIT_FIELD_DEFAULTS = new ArrayList<String>();
    private static final List<String> CREATE_FIELD_DEFAULTS;
    private static final String FIELD_SEPARATOR = ",";
    private final UserPropertyManager userPropertyManager;

    public UserPreferencesStoreImpl(UserPropertyManager userPropertyManager) {
        this.userPropertyManager = userPropertyManager;
    }

    @Override
    public UserPreferences getEditUserPreferences(User loggedInUser) {
        if (this.isAnonymous(loggedInUser)) {
            return new UserPreferences.Builder().showWelcomeScreen(false).useQuickForm(false).build();
        }
        PropertySet ps = this.userPropertyManager.getPropertySet(loggedInUser);
        UserPreferences.Builder builder = new UserPreferences.Builder();
        builder.showWelcomeScreen(this.getBooleanWithDefault(ps, "jira.quick.edit.show.welcome.screen", true)).useQuickForm(this.getBooleanWithDefault(ps, "jira.quick.edit.use", false)).fields(this.getEditFields(loggedInUser));
        return builder.build();
    }

    private boolean isAnonymous(User loggedInUser) {
        return loggedInUser == null;
    }

    @Override
    public void storeEditUserPreferences(User loggedInUser, UserPreferences prefs) {
        Assertions.notNull((String)"prefs", (Object)prefs);
        PropertySet ps = this.userPropertyManager.getPropertySet(loggedInUser);
        ps.setBoolean("jira.quick.edit.show.welcome.screen", prefs.isShowWelcomeScreen());
        ps.setBoolean("jira.quick.edit.use", prefs.isUseQuickForm());
        this.setFieldsForUser(loggedInUser, "jira.quick.edit.fields", prefs.getFields());
    }

    @Override
    public UserPreferences getCreateUserPreferences(User loggedInUser) {
        if (this.isAnonymous(loggedInUser)) {
            return new UserPreferences.Builder().showWelcomeScreen(false).useQuickForm(false).build();
        }
        PropertySet ps = this.userPropertyManager.getPropertySet(loggedInUser);
        UserPreferences.Builder builder = new UserPreferences.Builder();
        builder.showWelcomeScreen(this.getBooleanWithDefault(ps, "jira.quick.edit.show.welcome.screen", true)).useQuickForm(this.getBooleanWithDefault(ps, "jira.quick.create.use", false)).fields(this.getCreateFields(loggedInUser));
        return builder.build();
    }

    @Override
    public void storeCreateUserPreferences(User loggedInUser, UserPreferences prefs) {
        Assertions.notNull((String)"prefs", (Object)prefs);
        PropertySet ps = this.userPropertyManager.getPropertySet(loggedInUser);
        ps.setBoolean("jira.quick.edit.show.welcome.screen", prefs.isShowWelcomeScreen());
        ps.setBoolean("jira.quick.create.use", prefs.isUseQuickForm());
        this.setFieldsForUser(loggedInUser, "jira.quick.create.fields", prefs.getFields());
    }

    private List<String> getEditFields(User loggedInUser) {
        List<String> fieldsForUser = this.getFieldsForUser(loggedInUser, "jira.quick.edit.fields");
        if (fieldsForUser.isEmpty()) {
            return Collections.unmodifiableList(EDIT_FIELD_DEFAULTS);
        }
        return fieldsForUser;
    }

    private List<String> getCreateFields(User loggedInUser) {
        List<String> fieldsForUser = this.getFieldsForUser(loggedInUser, "jira.quick.create.fields");
        if (fieldsForUser.isEmpty()) {
            return Collections.unmodifiableList(CREATE_FIELD_DEFAULTS);
        }
        return fieldsForUser;
    }

    private void setFieldsForUser(User loggedInUser, String key, List<String> fields) {
        StringBuilder values = new StringBuilder();
        if (fields != null) {
            Iterator<String> iterator = fields.iterator();
            while (iterator.hasNext()) {
                values.append(iterator.next());
                if (!iterator.hasNext()) continue;
                values.append(FIELD_SEPARATOR);
            }
        }
        PropertySet userProperties = this.userPropertyManager.getPropertySet(loggedInUser);
        userProperties.setText(key, values.toString());
    }

    private List<String> getFieldsForUser(User loggedInUser, String key) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(loggedInUser);
        String userFields = userProperties.getText(key);
        ArrayList<String> ret = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)userFields)) {
            ret.addAll(Arrays.asList(userFields.split(FIELD_SEPARATOR)));
        }
        return Collections.unmodifiableList(ret);
    }

    private boolean getBooleanWithDefault(PropertySet ps, String key, boolean defaultValue) {
        if (ps.exists(key)) {
            return ps.getBoolean(key);
        }
        return defaultValue;
    }

    static {
        EDIT_FIELD_DEFAULTS.add("fixVersions");
        EDIT_FIELD_DEFAULTS.add("assignee");
        EDIT_FIELD_DEFAULTS.add("labels");
        EDIT_FIELD_DEFAULTS.add("components");
        EDIT_FIELD_DEFAULTS.add("priority");
        EDIT_FIELD_DEFAULTS.add("comment");
        CREATE_FIELD_DEFAULTS = new ArrayList<String>();
        CREATE_FIELD_DEFAULTS.add("summary");
        CREATE_FIELD_DEFAULTS.add("description");
        CREATE_FIELD_DEFAULTS.add("priority");
        CREATE_FIELD_DEFAULTS.add("versions");
        CREATE_FIELD_DEFAULTS.add("components");
    }
}

