/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.rest.api.field;

import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.quickedit.rest.api.UserPreferences;
import com.atlassian.jira.quickedit.rest.api.field.TabWithLabels;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement
public class QuickEditFields {
    @XmlElement(name="fields")
    private List<FieldHtmlBean> fields = new ArrayList<FieldHtmlBean>();
    @XmlElement(name="userPreferences")
    private UserPreferences userPreferences;
    @XmlElement(name="sortedTabs")
    private List<TabWithLabels> sortedTabs = new ArrayList<TabWithLabels>();
    @XmlElement(name="issueKey")
    private String issueKey;
    @XmlElement(name="atl_token")
    private String atlToken;
    @XmlElement(name="createdIssueDetails", nillable=true)
    private IssueBean createdIssueDetails;

    private QuickEditFields() {
    }

    private QuickEditFields(List<FieldHtmlBean> fields, UserPreferences userPreferences, Collection<TabWithLabels> sortedTabs, String createdIssueKey, String atlToken, IssueBean createdIssueDetails) {
        this.atlToken = atlToken;
        this.fields.addAll(fields);
        this.userPreferences = userPreferences;
        this.sortedTabs.addAll(sortedTabs);
        this.issueKey = createdIssueKey;
        this.createdIssueDetails = createdIssueDetails;
    }

    public List<FieldHtmlBean> getFields() {
        return this.fields;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public List<TabWithLabels> getSortedTabs() {
        return this.sortedTabs;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fields", this.fields).append("userPreferences", (Object)this.userPreferences).append("sortedTabs", this.sortedTabs).toString();
    }

    public static class Builder {
        private List<FieldHtmlBean> fields = new ArrayList<FieldHtmlBean>();
        private String createdIssueKey;
        private IssueBean createdIssueDetails;

        public Builder addFields(List<FieldHtmlBean> fields) {
            for (FieldHtmlBean field : fields) {
                this.addField(field);
            }
            return this;
        }

        public Builder addField(FieldHtmlBean field) {
            this.fields.add(field);
            return this;
        }

        public Builder createdIssue(String key) {
            this.createdIssueKey = key;
            return this;
        }

        public Builder createdIssueDetails(IssueBean issueBean) {
            this.createdIssueDetails = issueBean;
            return this;
        }

        public QuickEditFields build(UserPreferences prefs, String atlToken) {
            TreeMap<Integer, TabWithLabels> positionToTabMap = new TreeMap<Integer, TabWithLabels>();
            for (FieldHtmlBean field : this.fields) {
                if (field.getTab() == null) continue;
                int position = field.getTab().getPosition();
                if (!positionToTabMap.containsKey(position)) {
                    positionToTabMap.put(position, new TabWithLabels(field.getTab().getLabel()));
                }
                ((TabWithLabels)positionToTabMap.get(position)).add(new TabWithLabels.Field(field.getLabel(), field.getId()));
            }
            return new QuickEditFields(this.fields, prefs, positionToTabMap.values(), this.createdIssueKey, atlToken, this.createdIssueDetails);
        }
    }
}

