/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.action;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.rest.FieldHtmlFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.quickedit.action.JsonActionSupport;
import com.atlassian.jira.quickedit.rest.api.field.QuickEditFields;
import com.atlassian.jira.quickedit.user.UserPreferencesStore;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import webwork.action.Action;
import webwork.action.ActionContext;

public class QuickEditIssue
extends JiraWebActionSupport
implements OperationContext {
    private final UserPreferencesStore userPreferencesStore;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final FieldHtmlFactory fieldHtmlFactory;
    private final IssueService issueService;
    private final Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private boolean retainValues;
    private Long issueId;
    private boolean singleFieldEdit = false;
    private IssueService.UpdateValidationResult updateValidationResult;
    private final JsonActionSupport jsonActionSupport;

    public QuickEditIssue(IssueService issueService, UserPreferencesStore userPreferencesStore, UserIssueHistoryManager userIssueHistoryManager, FieldHtmlFactory fieldHtmlFactory) {
        this.issueService = issueService;
        this.userPreferencesStore = userPreferencesStore;
        this.userIssueHistoryManager = userIssueHistoryManager;
        this.fieldHtmlFactory = fieldHtmlFactory;
        this.jsonActionSupport = new JsonActionSupport();
    }

    public String doDefault() throws Exception {
        IssueService.IssueResult result = this.issueService.getIssue(this.getLoggedInUser(), this.issueId);
        MutableIssue issue = result.getIssue();
        if (!result.isValid() || result.getIssue() == null) {
            return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection()));
        }
        if (!this.issueService.isEditable((Issue)issue, this.getLoggedInUser())) {
            return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)this.getSimpleErrorCollection("editissue.error.no.edit.permission")));
        }
        QuickEditFields.Builder fieldsBuilder = new QuickEditFields.Builder();
        List editFields = this.fieldHtmlFactory.getEditFields(this.getLoggedInUser(), (OperationContext)this, (Action)this, (Issue)issue, this.retainValues);
        fieldsBuilder.addFields(editFields);
        return this.jsonActionSupport.asJson(fieldsBuilder.build(this.userPreferencesStore.getEditUserPreferences(this.getLoggedInUser()), this.getXsrfToken()));
    }

    private int getErrorReturnCode() {
        if (this.getLoggedInUser() == null) {
            return 401;
        }
        return 400;
    }

    private ErrorCollection getValidationErrors() {
        IssueService.IssueResult result = this.issueService.getIssue(this.getLoggedInUser(), this.issueId);
        MutableIssue issue = result.getIssue();
        if (!result.isValid() || result.getIssue() == null) {
            return ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection());
        }
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters(ActionContext.getParameters());
        if (this.singleFieldEdit) {
            issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(this.singleFieldEdit, true);
        } else {
            issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(this.singleFieldEdit);
        }
        this.updateValidationResult = this.issueService.validateUpdate(this.getLoggedInUser(), issue.getId(), issueInputParameters);
        this.setFieldValuesHolder(this.updateValidationResult.getFieldValuesHolder());
        if (!this.updateValidationResult.isValid()) {
            return ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)this.updateValidationResult.getErrorCollection());
        }
        return ErrorCollection.of((String[])new String[0]);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ErrorCollection validationErrors = this.getValidationErrors();
        if (validationErrors.hasAnyErrors()) {
            return this.jsonActionSupport.asJson(400, validationErrors);
        }
        try {
            IssueService.IssueResult issueResult = this.issueService.update(this.getLoggedInUser(), this.updateValidationResult);
            if (!issueResult.isValid()) {
                return this.jsonActionSupport.asJson(400, ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)issueResult.getErrorCollection()));
            }
            this.userIssueHistoryManager.addIssueToHistory(this.getLoggedInUser(), (Issue)issueResult.getIssue());
            return this.jsonActionSupport.asJsonOK();
        }
        catch (Throwable e) {
            this.log.error((Object)("Exception occurred editing issue: " + e), e);
            return this.jsonActionSupport.asJson(400, ErrorCollection.of((String[])new String[]{this.getText("admin.errors.issues.exception.occured", e)}));
        }
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public void setIssueId(Long issueId) {
        this.issueId = issueId;
    }

    private SimpleErrorCollection getSimpleErrorCollection(String ... errorMessages) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        for (String errorMessage : errorMessages) {
            simpleErrorCollection.addErrorMessage(this.getText(errorMessage));
        }
        return simpleErrorCollection;
    }

    public Map getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    public void setFieldValuesHolder(Map<String, Object> fieldValuesHolder) {
        this.fieldValuesHolder.clear();
        this.fieldValuesHolder.putAll(fieldValuesHolder);
    }

    public boolean isRetainValues() {
        return this.retainValues;
    }

    public void setRetainValues(boolean retainValues) {
        this.retainValues = retainValues;
    }

    public boolean isSingleFieldEdit() {
        return this.singleFieldEdit;
    }

    public void setSingleFieldEdit(boolean singleFieldEdit) {
        this.singleFieldEdit = singleFieldEdit;
    }

    public IssueOperation getIssueOperation() {
        return IssueOperations.EDIT_ISSUE_OPERATION;
    }
}

