AJS.test.require("com.atlassian.jira.jira-projects-plugin:subnavigator-test", function() {
    "use strict";

    var jQuery = require("jquery");
    var Items = require("jira/projects/components/subnavigator/entities/items");
    var Title = require("jira/projects/components/subnavigator/views/title");

    var ITEM_1 = { id: "item1", label: "Item 1", description: "Item 1"};
    var ITEM_2 = { id: "item2", label: "Item 2", description: "Item 2" };
    var ITEMS = [[ITEM_1], [ITEM_2]];

    module("jira/projects/components/subnavigator/views/title", {
        setup: function() {
            this.$el = jQuery("<div/>");
            this.model = new Items({itemGroups: ITEMS});
            this.view = new Title({
                el: this.$el,
                model: this.model
            });
        }
    });

    test("Uses the label of the selected item to render the title", function() {
        this.model.selectItem(ITEM_2.id);

        var viewData = this.view.serializeData();

        equal(viewData.title, ITEM_2.label);
    });
});
