define('jira/projects/components/subnavigator/views/content', [
    "jira/projects/components/subnavigator/templates",
    "underscore",
    "jira/projects/libs/marionette",
    "jquery"
], function(Templates, _, Marionette, jQuery) {
    "use strict";

    return Marionette.ItemView.extend({
        template: Templates.content,
        tooltipTimer: null,
        ui: {
            item: "li"
        },

        initialize: function() {
            this.tooltipTimeout = this.options.tooltipTimeout || 600;
            this.hideSelectedItem = _.has(this.options, "hideSelectedItem") ? this.options.hideSelectedItem : true;
        },

        _hideTooltips: function() {
            clearTimeout(this.tooltipTimer);
            jQuery(".tipsy").remove();
        },

        events: {
            "click @ui.item": function(e) {
                this._hideTooltips();
                var item = jQuery(e.target).attr("data-item-id");
                this.trigger("click", item);
            },
            "mouseenter @ui.item": function(ev) {
                this._hideTooltips();
                this.tooltipTimer = setTimeout(function() {
                    jQuery(ev.currentTarget).tipsy("show");
                }, this.tooltipTimeout);
            },
            "mouseleave @ui.item": "_hideTooltips",
            "aui-dropdown2-hide": "_hideTooltips"
        },

        serializeData: function() {
            var selectedItem = this.model.get("selectedItem");
            var itemGroups = this.model.get("itemGroups");
            var hideSelectedItem = this.hideSelectedItem;
            if (selectedItem) {
                itemGroups = _.map(itemGroups, function(itemGroup) {
                    if (hideSelectedItem) {
                        return _.reject(itemGroup, function(item) {
                            return item.id === selectedItem.id;
                        });
                    } else {
                        return _.map(itemGroup, function(item) {
                            var response = _.clone(item);
                            if (response.id === selectedItem.id) {
                                response.selected = true;
                            }
                            return response;
                        });

                    }
                });
            }

            return {
                itemGroups: itemGroups,
                hideSelectedItem: hideSelectedItem,
                idSuffix: this.options.id || ""
            };
        },
        onRender: function() {
            this.unwrapTemplate();
            this._hideTooltips();
            /*
             * AUI's tooltip shows automatically by default.
             * On that mode, whenever the mouse enters the DOM element, a timeout will be scheduled to show the tooltip.
             * The problem with that is that they don't provide any way for us to cancel the timer once the mouse leaves.
             *
             * To solve this problem we are going to use AUI's tooltip in manual mode and we are going to be
             * in control of scheduling the tooltips and canceling them when the mouse enters/leaves the different options.
             */
            jQuery(this.ui.item).tooltip({gravity: "w", trigger: "manual"});
        }
    });
});
