define("jira/projects/components/pinnable-navigator/views/navigator-view/pinned-view", [
    "jira/projects/components/pinnable-navigator/templates",
    "jira/projects/components/pinnable-navigator/views/navigator-view/navigator-view",
    "jira/projects/components/pinnable-navigator/views/list-view/pinned-list-view"
], function(Templates, NavigatorView, PinnedListView) {
    "use strict";

    return NavigatorView.extend({
        template: Templates.pinnedNav,

        initialize: function() {
            this.listItemsView = new PinnedListView({
                model: this.options.model,
                id: this.options.id || "",
                title: this.options.title,
                manageText: this.options.manageText,
                emptyText: this.options.emptyText,
                tooltipTimeout: this.options.tooltipTimeout,
                searchView: this.options.searchView
            });

            this.listenTo(this.listItemsView, {
                "itemSelected": function (data) {
                    this.trigger("itemSelected", data);
                }
            });
        },
        //Add the list to this component
        putListintoView: function(){
            this.listItemsView.setElement(this.$(".js-pinned-items-list"));
            this.renderList();
        },

        unpin: function() {
            this.$el.remove();
        }
    });
});
