define("jira/projects/components/pinnable-navigator/views/trigger", [
    "jira/util/formatter",
    "jira/projects/components/pinnable-navigator/templates",
    "jira/projects/libs/marionette"
], function(formatter, Templates, Marionette) {
    "use strict";

    return Marionette.ItemView.extend({
        template: Templates.unpinnedTrigger,

        serializeData: function() {
            // Always show the button, so user can open dropdown menu and add more items
            var selectedItem = this.model.get("selectedItem");
            var switchText = formatter.I18n.getText("project.subnavigator.manage.switch");
            var label = selectedItem ? selectedItem.label : switchText;
            if (this.options.label) {
                label = switchText + ' ' + this.options.label;
            }
            return {
                label: label,
                idSuffix: this.options.id || ""
            };
        },
        onRender: function() {
            this.unwrapTemplate();
        }
    });
});
