define('jira/projects/sidebar/scopefilter/scopefilter-view', [
    'jquery',
    'jira/projects/libs/marionette',
    'jira/projects/sidebar/scopefilter/templates'
], function ($,
             Marionette,
             Templates) {
    'use strict';

    return Marionette.ItemView.extend({
        template: Templates.renderScopefilterItems,
        events: {
            'aui-dropdown2-show': 'show'
        },
        initialize: function (options) {
            this.controller = options.controller;
            this.rendered = false;
        },
        show: function () {
            // once the view is rendered no need to re-render it, because data doesn't change without page reload
            if (this.rendered) {
                return
            }
            var $spinner = $('<aui-spinner size="small"/>').css('margin', 'auto');
            this.$el.prepend($spinner);
            this.$el.addClass('data-load-in-progress');
            this.controller.fetchScopeFilterList()
                .then(this.onFetchSuccess.bind(this))
                .fail(this.onFetchFail.bind(this))
                .always(function () {
                    this.$el.addClass('data-load-finished').removeClass('data-load-in-progress');
                    $spinner.remove();
                }.bind(this));
        },
        onFetchSuccess: function() {
            this.$el.addClass('data-load-success');
            var selectableScopes = this.model.getSelectableScopes();
            var canCreateScope = !!this.model.getCreateScopeActions().length;
            if (selectableScopes) {
                /**
                 * Marionette 2.x doesn't seem to have a documented "attachEl" method to define how template is attached.
                 * In 2.x we will have to define an extra Layout view with a region that defines how this view.el will be attached to it.
                 * All this will lead to lot of bloated code (hence removed from later versions of marionette ;)
                 * so I'm just gonna do this and keep it simple.
                 */
                var html = this.template({
                    scopeFilterItems: selectableScopes,
                    canCreateScope: canCreateScope
                });
                this.$el.prepend(html);
                this.rendered = true;
            }
        },
        onFetchFail: function() {
            this.$el.addClass('data-load-fail');
            var html = Templates.scopeListError();
            this.$el.prepend(html);
            this.rendered = true;
            this.$el.find('.scope-filter-error-message-container .aui-button')
                .on('click', this.onRetryClick.bind(this));
        },
        onRetryClick: function (e) {
            // prevent closing the dropdown on button click
            e.stopPropagation();

            // Since we use prepend to avoid re-creation of "create" button, we have to remove
            // error container manually before next step
            var $errorContainer = this.$el.find('.scope-filter-error-message-container');
            if ($errorContainer.length) {
                $errorContainer.remove();
            }
            this.rendered = false;
            return this.show();
        }
    });
});

