AJS.test.require(["com.atlassian.jira.jira-projects-plugin:scope-filter"], function(){
    "use strict";

    var jQuery = require("jquery");
    var _ = require("underscore");
    var Controller = require("jira/projects/sidebar/scopefilter/controller");
    var Model = require("jira/projects/sidebar/scopefilter/model");

    module("jira/projects/sidebar/scopefilter/collapsed-initializer", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();

            this.sandbox.stub(Model.prototype, 'setData');
            this.sandbox.stub(Model.prototype, 'shouldDisplayWhenSidebarIsCollapsed');
            this.sandbox.spy(Controller.prototype, 'createCollapsedScopeFilterView');
            this.sandbox.spy(Controller.prototype, 'createScopeFilterView');


            this.Model = this.sandbox.spy(Model);
            this.Controller = this.sandbox.spy(Controller);

            this.$fixture = jQuery('#qunit-fixture');
            this.$fixture.append('<div id="existing-child"></div>');

            this.sidebar = {
                callbacks: {},

                on: function(event, callback) {
                    this.callbacks[event] = this.callbacks[event] || [];
                    this.callbacks[event].push(callback);
                },

                trigger: function(event) {
                    this.callbacks[event] = this.callbacks[event] || [];
                    _.each(this.callbacks[event], function(callback) {
                        callback();
                    });
                },

                isCollapsed: this.sandbox.stub()
            };
            this.sandbox.spy(this.sidebar, 'on');

            this.sidebarAPI = {};
            this.sidebarAPI.isProjectSidebar = this.sandbox.stub();
            this.sidebarAPI.getContentContainer = this.sandbox.stub().returns(this.$fixture);
            this.sidebarAPI.getAUISidebar = function (){ return this.sidebar}.bind(this);

            /*var CollapsedInitializer = this.context.require("jira/projects/sidebar/scopefilter/collapsed-initializer");
            this.initializer = new CollapsedInitializer({
                sidebarAPI: this.sidebarAPI,
                scopeFilterData: {
                    scopes: [],
                    createScopeActions: []
                },
                sidebar: this.sidebar,
                $sidebarContentContainer: this.$fixture
            });*/
        },

        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("Should do nothing when on a global sidebar", function(){
        this.sidebarAPI.isProjectSidebar.returns(false);
        new this.Controller({
            sidebarAPI: this.sidebarAPI
        });

        //this.initializer.run();

        sinon.assert.notCalled(this.Model);

        equal(this.$fixture.children().length, 1);
        equal(this.$fixture.children()[0].getAttribute('id'), 'existing-child');

        //sinon.assert.notCalled(this.Controller);

        sinon.assert.notCalled(this.sidebar.on);
    });

    test("Should do nothing when on a project sidebar and there is nothing the user can select from the scope filter", function(){
        this.sidebarAPI.isProjectSidebar.returns(true);
        new this.Controller({
            sidebarAPI: this.sidebarAPI
        });

        sinon.assert.calledOnce(this.Model.prototype.setData);

        equal(this.$fixture.children().length, 1);
        equal(this.$fixture.children()[0].getAttribute('id'), 'existing-child');

        //sinon.assert.notCalled(this.Controller);

        //sinon.assert.notCalled(this.sidebar.on);
    });

    test("Should do initialize when on a project sidebar and there are selections available to the user in the scope filter", function(){
        this.sidebarAPI.isProjectSidebar.returns(true);
        this.sidebar.isCollapsed.returns(true);
        this.Model.prototype.shouldDisplayWhenSidebarIsCollapsed.returns(true);

        //this.initializer.run();
        new this.Controller({
            sidebarAPI: this.sidebarAPI
        });

        sinon.assert.calledOnce(this.Model.prototype.setData);

        equal(this.$fixture.children().length, 2);
        equal(this.$fixture.children().first().find('.collapsed-scope-filter-container').length, 1);
        equal(this.$fixture.children()[1].getAttribute('id'), 'existing-child');

        //sinon.assert.calledOnce(this.Controller);

        this.sidebar.trigger('collapse-start');
        sinon.assert.calledOnce(Controller.prototype.createCollapsedScopeFilterView);

        this.sidebar.trigger('expand-end');
        sinon.assert.calledOnce(Controller.prototype.createScopeFilterView);
    });

    test("Should render the collapsed view when the sidebar starts is initially loaded in the collapsed state", function(){
        this.sidebar.isCollapsed.returns(true);
        this.sidebarAPI.isProjectSidebar.returns(true);
        this.Model.prototype.shouldDisplayWhenSidebarIsCollapsed.returns(true);

        //this.initializer.run();
        new this.Controller({
            sidebarAPI: this.sidebarAPI
        });
        sinon.assert.calledOnce(this.Controller.prototype.createCollapsedScopeFilterView);
    });
});
