define("jira/projects/sidebar/reports/link-storage", [
    "jira/util/logger",
    "jira/data/local-storage",
    "jira/api/projects",
    "jira/api/projects/sidebar"
], function (logger, localStorage, ProjectsAPI, SidebarAPI) {
    "use strict";

    function createLastViewedReportKey(sidebar) {
        var scopeFilterId = sidebar.getSelectedScopeFilterId();
        var projectKey = ProjectsAPI.getCurrentProjectKey();

        var key = "last.viewed.report." + projectKey;
        if (scopeFilterId) {
            key += "." + scopeFilterId;
        }
        return key;
    }

    function setReportsItemLink(sidebar, reportUrl) {
        sidebar.setReportsItemLink(reportUrl);
    }

    return {
        storeLastViewedReportLink: function (reportUrl) {
            SidebarAPI.getSidebar().done(function (sidebar) {
                if (sidebar.isProjectSidebar()) {
                    var key = createLastViewedReportKey(sidebar);
                    localStorage.setItem(key, reportUrl);
                    setReportsItemLink(sidebar, reportUrl);
                }
                logger.trace("jira.projects.sidebar.reports.link.stored");
            });
        },

        restoreLastViewedReportLink: function () {
            SidebarAPI.getSidebar().done(function (sidebar) {
                if (sidebar.isProjectSidebar()) {
                    var key = createLastViewedReportKey(sidebar);
                    var reportUrl = localStorage.getItem(key);
                    if (reportUrl) {
                        setReportsItemLink(sidebar, reportUrl);
                    }
                }
                logger.trace("jira.projects.sidebar.reports.link.restored");
            });
        }
    };
});
