define("jira/projects/sidebar/component/navigation-group-factory", [
    "exports",
    "jira/projects/sidebar/component/navigation-item",
    "jira/projects/sidebar/component/navigation-subgroup",
    "jquery"
], function(exports, NavigationItem, NavigationSubgroup, $) {
    "use strict";

    exports.build = function buildNavigationGroup(element) {
        var instance;

        if ($(element).find("ul").length) {
            instance = new NavigationSubgroup({
                el: element
            });
        } else {
            instance = new NavigationItem({
                el: element
            });
        }

        return instance;
    };
});
