AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-analytics"], function(){
    "use strict";

    var hash = require("jira/projects/sidebar/analytics/hash");

    module('jira/projects/sidebar/analytics/hash', {
        teardown: function() {
            hash.clearPrefixes();
        }
    });

    test('prefixedHash returns an empty string for the empty string', function () {
        equal(hash.prefixedHash("").prefix, "");
        equal(hash.prefixedHash("").hash, "");
    });

    test('prefixedHash returns prefix plus a hash of the remainder', function () {
        hash.addPrefix("prefix-");
        equal(hash.prefixedHash("prefix-foo").prefix, "prefix-");
        equal(hash.prefixedHash("prefix-foo").hash, "prefix-101574");
    });

    test('prefixedHash returns a hash of the whole string if no string matches', function () {
        hash.addPrefix("potato-");
        equal(hash.prefixedHash("potatoes-123").prefix, "");
        equal(hash.prefixedHash("potatoes-123").hash, "-2135528582");
    });

    test('prefixedHash does not separate prefix if prefix is not at the start', function () {
        hash.addPrefix("potato-");
        equal(hash.prefixedHash("one-potato-two-potato").prefix, "");
        equal(hash.prefixedHash("one-potato-two-potato").hash, "1677441159");
    });

});

