define("jira/projects/page/summary/navigation/navigation", [
    "jira/ajs/ajax/smart-ajax",
    "jira/message",
    "jira/api/projects",
    "jira-projects-backbone",
    "underscore",
    "wrm/context-path",
    "jquery",
    "exports"
], function(
    SmartAjax,
    Messages,
    ProjectsAPI,
    Backbone,
    _,
    wrmContextPath,
    jQuery,
    exports
) {
    "use strict";

    var showErrorMessage = function (response) {
        Messages.showErrorMsg(SmartAjax.buildSimpleErrorContent(response), {
            closeable: true
        });
    };

    var loadContentFor = function (url, el) {
        return jQuery.ajax({
            url: url,
            type: "GET"
        }).done(function (html) { el.html(html); }).fail(showErrorMessage);
    };

    var Navigation = function () {
        return _.extend({
            start: function (el, subnavigator, router) {
                var self = this;

                var projectKey = encodeURIComponent(ProjectsAPI.getCurrentProjectKey());
                var baseUrl = wrmContextPath() + "/projects/" + projectKey;

                var updatePageContent = function (contentUrl, subnavigatorSelectedItem) {
                    var url = baseUrl + contentUrl;
                    loadContentFor(url, el).done(function () {
                        self.trigger("pageRefreshed");
                        subnavigator.selectItem(subnavigatorSelectedItem);
                    });
                };

                router.on("statistics", function () {
                    updatePageContent("?selectedItem=com.atlassian.jira.jira-projects-plugin:issues-panel&decorator=none&contentOnly=true", "statistics");
                    self.trigger("statisticsPageSelected");
                });

                router.on("activity", function () {
                    updatePageContent("?selectedItem=com.atlassian.jira.jira-projects-plugin:project-activity-summary&decorator=none&contentOnly=true", "activity");
                    self.trigger("activityPageSelected");
                });

                subnavigator.on("itemSelected", function (e) {
                    var itemId = e.item.id;
                    if (itemId === "statistics") {
                        router.goToStatistics();
                    }
                    else {
                        router.goToActivity();
                    }
                });

                subnavigator.show();
            }
        }, Backbone.Events);
    };

    exports.create = function() {
        return new Navigation();
    };
});

AJS.namespace("JIRA.Projects.Summary.Navigation", null, require("jira/projects/page/summary/navigation/navigation"));
