AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-navigation-test", function() {
    "use strict";

    var _ = require("underscore");
    var Backbone = require("jira-projects-backbone");
    var analytics = require("jira/analytics");
    var NavigationAnalytics = require("jira/projects/page/summary/navigation/navigation-analytics");

    module("jira/projects/page/summary/navigation/navigation-analytics", {
        setup: function() {
            this.navigation = _.extend({}, Backbone.Events);
            this.navigationAnalytics = NavigationAnalytics.create();

            this.navigationAnalytics.start(this.navigation);
        }
    });

    test("When the statistics page is selected, an analytics event is triggered", function() {
        this.spy(analytics, "send");

        this.navigation.trigger("statisticsPageSelected");

        sinon.assert.calledWith(analytics.send, sinon.match.hasOwn("name", "jira.projects.summary.page.issue.statistics.selected"));
    });

    test("When the activity page is selected, an analytics event is triggered", function() {
        this.spy(analytics, "send");

        this.navigation.trigger("activityPageSelected");

        sinon.assert.calledWith(analytics.send, sinon.match.hasOwn("name", "jira.projects.summary.page.activity.stream.selected"));
    });
});
