AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-issue-vignettes-navigation-test", function() {
    "use strict";

    module("jira/projects/page/summary/issue/vignettes/switcher", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();

            var switcher = require("jira/projects/page/summary/issue/vignettes/switcher");
            var jQuery = require("jquery");
            this.switcher = switcher.start(jQuery("<div />"), jQuery("<div />"), jQuery("<div />"));
        },

        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("When an item is clicked, an 'itemSelected' event is triggered", function() {
        this.spy(this.switcher, "trigger");

        this.switcher.clickItem("switcherItem");

        sinon.assert.calledOnce(this.switcher.trigger);
        sinon.assert.calledWith(this.switcher.trigger, "itemSelected", {
            item: { id: "switcherItem" }
        });
    });
});
