define("jira/projects/page/summary/issue/vignettes/manager", [
    "jira/projects/page/summary/issue/vignettes/statussummary",
    "jira/projects/page/summary/issue/vignettes/prioritysummary",
    "jira/projects/page/summary/issue/vignettes/assigneesummary",
    "underscore",
    "jira-projects-backbone"
], function(
    StatusVignette,
    PriorityVignette,
    AssigneeVignette,
    _,
    Backbone
) {
    "use strict";

    var switchableVignettes = [
        PriorityVignette,
        AssigneeVignette
    ];

    var standaloneVignettes = [
        StatusVignette
    ];

    var registerRetriggerOfEventsForVignette = function(vignette, vignetteManager) {
        vignette.getEventNames().forEach(function(eventName) {
            vignette.off(eventName).on(eventName, function(eventData) {
                vignetteManager.trigger(eventName, eventData);
            });
        });
    };

    return _.extend({
        getDefaultSwitchableVignetteId: function() {
            return _.first(switchableVignettes).getId();
        },

        getSwitchableVignetteById: function(vignetteId) {
            return _.find(this.getSwitchableVignettes(), function(vignette) {
                return vignetteId === vignette.getId();
            });
        },

        getAllVignettes: function() {
            return switchableVignettes.concat(standaloneVignettes);
        },

        getSwitchableVignettes: function() {
            return switchableVignettes;
        },

        hideSwitchableVignettes: function() {
            this.getSwitchableVignettes().forEach(function(vignette) {
                vignette.hide();
            });
        },

        showVignetteWithId: function(vignetteId) {
            this.hideSwitchableVignettes();
            this.getSwitchableVignetteById(vignetteId).show();
        },

        start: function() {
            this.getAllVignettes().forEach(_.bind(function(vignette) {
                vignette.start();
                registerRetriggerOfEventsForVignette(vignette, this);
            }, this));
        }
    }, Backbone.Events);
});
