AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-issue-vignette-manager-test-resources", function() {
    "use strict";

    var _ = require("underscore");
    var Backbone = require("jira-projects-backbone");

    module("jira/projects/page/summary/issue/vignettes/manager", {
        setup: function() {
            this.vignettes = require("jira/projects/page/summary/issue/vignettes/manager");
        },

        mockVignetteWithEventName: function(eventName) {
            return _.extend({
                getEventNames: function() {
                    return [eventName];
                },
                start: function() {}
            }, Backbone.Events);
        },

        vignetteThatTheManagerKnowsAboutIs: function(vignette) {
            return this.stub(this.vignettes, "getAllVignettes").returns([vignette]);
        }
    });

    test("When its vignette triggers an event, it retriggers that event with the corresponding data", function() {
        var expectedEventName = "someEvent";
        var expectedData = { someKey: "some value" };
        var vignette = this.mockVignetteWithEventName(expectedEventName);
        this.vignetteThatTheManagerKnowsAboutIs(vignette);
        this.spy(this.vignettes, "trigger");
        this.vignettes.start();

        vignette.trigger(expectedEventName, expectedData);

        sinon.assert.calledOnce(this.vignettes.trigger);
        sinon.assert.calledWith(this.vignettes.trigger, expectedEventName, expectedData);
    });
});
