define("jira/projects/page/summary/issue/vignettes/analytics", [
    "jira/analytics"
], function(
    analytics
) {
    "use strict";

    var triggerAnalyticsEvent = function(eventName, eventData) {
        analytics.send({
            name: eventName,
            data: eventData
        });
    };

    return {
        startAnalyticsForGoToStatisticsLink: function(statisticsLink) {
            statisticsLink.on({
                "statisticsLinkClicked": function() {
                    triggerAnalyticsEvent("jira.projects.summary.page.gotostatistics.link.clicked");
                }
            });
        },

        startAnalyticsForVignetteNavigation: function(navigation) {
            navigation.on({
                "vignetteSelected": function(eventData) {
                    triggerAnalyticsEvent("jira.projects.summary.page.vignetteswitcher.item.selected", eventData);
                }
            });
        },

        startAnalyticsForVignettes: function(vignettes) {
            vignettes.on({
                "statusLinkClicked": function(eventData) {
                    triggerAnalyticsEvent("jira.projects.summary.page.statussummarybar.link.clicked", eventData);
                },
                "statusDialogShown": function() {
                    triggerAnalyticsEvent("jira.projects.summary.page.statussummarybar.category.breakdown.displayed");
                },
                "priorityLinkClicked": function(eventData) {
                    triggerAnalyticsEvent("jira.projects.summary.page.prioritysummary.link.clicked", eventData);
                },
                "priorityDialogShown": function() {
                    triggerAnalyticsEvent("jira.projects.summary.page.prioritysummary.more.priorities.displayed");
                },
                "assigneeLinkClicked": function(eventData) {
                    triggerAnalyticsEvent("jira.projects.summary.page.assigneesummary.link.clicked", eventData);
                },
                "assigneeDialogShown": function() {
                    triggerAnalyticsEvent("jira.projects.summary.page.assigneesummary.more.assignees.displayed");
                }
            });
        }
    };
});
