require([
    "jquery",
    "jira/skate",
    "jira/api/projects",
    "jira/projects/page/release/release-page-app",
    "jira/projects/release/submit-model",
    "jira/projects/abstract-model/submit-model-states",
    "jira/dialog/form-dialog",
    "jira/projects/release/analytics",
    "jira/flag"
], function (
    $,
    skate,
    Projects,
    ReleasePageApp,
    SubmitModel,
    SubmitModelStates,
    FormDialog,
    Analytics,
    jiraFlag
) {
    "use strict";

    ReleasePageApp.on("navigate", Analytics.navigate);
    ReleasePageApp.on("progressDialogClicked", Analytics.progressDialogClick);

    var metrics = window['browser-metrics'] || {
        start: function () {
        }, end: function () {
        }
    };

    var VERSIONS_PAGE_KEY = "jira.projects.versions";

    skate("releases-page-app", {
        type: skate.type.CLASSNAME,
        attached: function (element) {
            var spinner = $(element).spin('large');

            metrics.start({
                key: VERSIONS_PAGE_KEY,
                isInitial: true
            });

            require("jira/projects/page/release/release-page-data")
                .done(function (data) {
                    ReleasePageApp.start({
                        container: $(element),
                        data: data
                    });

                    $(element).attr('data-ready', true)
                    metrics.end({key: VERSIONS_PAGE_KEY});
                })
                .fail(function (err) {
                    jiraFlag.showErrorMsg(null, err, {persistent: true, close: 'never'})
                });
        }
    });

    new FormDialog({
        defineResources: function () {
            this.requireResource("com.atlassian.jira.jira-projects-plugin:version-edit-init");
        },

        trigger: ".version-edit-dialog",

        submitHandler: function (event, callback) {
            var $form = this.$popupContent.find('.version-edit-form');
            $form
                .one("submitSuccess.versionEditDialog", this.options.onDialogFinished.bind(this))
                .one("submitFinished", function () {
                    $form.off(".versionEditDialog");
                    callback();
                });
        },

        onDialogFinished: function () {
            var versionId = this.$popupContent.find('[type=hidden][name=id]').val();

            var submitModel = new SubmitModel({id: versionId, project: Projects.getCurrentProjectId()});

            submitModel.detailsSync().done(function () {
                var model = ReleasePageApp.pageableItems.updateElement(submitModel);
                model.set("state", SubmitModelStates.SUCCESSFUL);

                setTimeout(function () {
                    model.set("state", SubmitModelStates.READY);
                }, 5000);
            });

            this.hide();
        }
    });

});

AJS.namespace("JIRA.Projects.Release.App", null, require("jira/projects/page/release/release-page-app"));
