define("jira/projects/release/merge-view", [
    "jira/ajs/select/multi-select",
    "jira/dialog/form-dialog",
    "jira-project-config/versions/merge-form",
    "jira/projects/release/templates",
    "jira/projects/libs/marionette",
    "jquery"
], function(MultiSelect, FormDialog, MergeForm, Templates, Marionette, jQuery) {
    "use strict";

    return Marionette.ItemView.extend({
        template: Templates.merge,

        ui: {
            "mergeButton": "#versions-merge"
        },

        onRender: function () {
            this.ui.mergeButton.on("click", this.mergeVersions.bind(this));
        },

        initialize: function (options) {
            this.pageableItems = options.pageableItems;
            this.isProjectAdmin = !!options.isProjectAdmin;
        },

        serializeData: function serializeData() {
            return {
                isProjectAdmin: this.isProjectAdmin,
                versionsSize: this.pageableItems.originalCollection.length
            };
        },

        mergeVersions: function (e) {
            e.preventDefault();
            var dialogForm = new MergeForm({
                collection: this.pageableItems.originalCollection
            });

            var fillIdsToMerge = function (serializedForm) {
                if (serializedForm.idsToMerge) {
                    serializedForm.idsToMerge = Array.isArray(serializedForm.idsToMerge) ? serializedForm.idsToMerge : [serializedForm.idsToMerge];
                } else {
                    serializedForm.idsToMerge = [];
                }
                return serializedForm;
            };

            var dialog = new FormDialog({
                id: "versionsMergeDialog",
                content: function (callback) {
                    dialogForm.render(function (el) {
                        callback(el);
                    });
                },
                submitHandler: function (e) {
                    var ids = fillIdsToMerge(this.$form.serializeObject());
                    if (dialog.$popup.find("#idsToMerge + .error").length > 0) {
                        dialog.hideFooterLoadingIndicator();
                        dialog.$popup.find(".aui-button:disabled").removeAttr("disabled");
                    } else if(ids.idsToMerge.length === 0) {
                        dialog.hide();
                    } else {
                        dialogForm.submit(ids, function () {
                            dialog.hide();
                        });
                    }
                    e.preventDefault();
                }
            });

            dialog.onContentReady(function () {
                var el = jQuery("#versionsMergeDialog select[multiple]");
                new MultiSelect({
                    element: el,
                    itemAttrDisplayed: "label"
                });
            });

            dialog.show();

            return dialog;
        }
    });
});
