define("jira/projects/release/analytics", ["jira/analytics", "jira/projects/abstract-list/navigation-utils"], function(analytics, NavigationUtils) {
    "use strict";

    var triggerEvent = function (key, data) {
        analytics.send({
            name: key,
            data: data || {}
        });
    };

    return {
        progressDialogClick: function () {
            triggerEvent("jira.projects.release.progress.dialog.click");
        },
        navigate: function navigate() {
            var status = NavigationUtils.getQueryStringParam("status", true) || "unreleased";
            var contains = NavigationUtils.getQueryStringParam("contains", true) || "";
            var page = +NavigationUtils.getQueryStringParam("page", true) || 1;

            triggerEvent("jira.projects.release.navigate", {
                status: status,
                containsLength: contains.length,
                page: page
            });
        },

        emptyViewRendered: function () {
            triggerEvent("jira.projects.release.empty.view");
        },

        releaseLearnMoreClicked: function () {
            triggerEvent("jira.projects.release.learn.more.click");
        },

        showEditVersion: function() {
            triggerEvent("jira.projects.release.edit.show");
        },

        editVersionFail: function() {
            triggerEvent("jira.projects.release.edit.fail");
        },

        editVersionSuccess: function() {
            triggerEvent("jira.projects.release.edit.success");
        }
    };
});
