define("jira/projects/components/submitcontroller", [
    "jira/projects/libs/marionette",
    "jira/ajs/ajax/ajax-util",
    "jira/flag",
    "jira/featureflags/feature-manager",
    "jira/projects/components/submitmodel",
    "jira/projects/abstract-model/submit-model-states",
    "jira/projects/components/submitview",
    "jira/projects/abstract-list/submit-controller",
    "jira/projects/components/analytics",
    "jira/util/formatter"
], function(
    Marionette,
    ajaxUtil,
    jiraFlag,
    FeatureManager,
    SubmitModel,
    SubmitModelStates,
    SubmitView,
    AbstractSubmitController,
    Analytics,
    formatter
) {
    var SubmitController = AbstractSubmitController.extend({
        initialize: function(options) {
            this.pageableItems = options.pageableItems;
            if(this.pageableItems) {
                this.listenTo(this.pageableItems, 'added-hidden-item', this.showHiddenFlag);
            }
            this._viewModel = new SubmitModel({
                displayableProjectLead: options.displayableProjectLead,
                isDefaultAssigneeProjectLead: options.isDefaultAssigneeProjectLead
            });
            Analytics.listenForActionsOnItem(this);
        },

        showView: function() {
            var view = new SubmitView({
                project: this.options.project,
                displayableProjectLead: this.options.displayableProjectLead,
                isDefaultAssigneeProjectLead: this.options.isDefaultAssigneeProjectLead,
                model: this._viewModel,
                pageableItems: this.options.pageableItems
            });

            this.listenTo(view, "save", this.componentAdd);
            return view;
        },

        componentAdd: function (formModel) {
            var model = new SubmitModel(formModel.toJSON());

            this.trigger("createItemEvent", {
                nameLength: model.attributes.name.length,
                leadNameLength: model.attributes.leadUserName.length,
                descriptionLength: model.attributes.description.length,
                assigneeType: model.attributes.assigneeType
            });

            this.listenTo(model, "retry-add", function () {
                this._componentAdd(model, false, SubmitModelStates.IN_PROGRESS_ERROR);
            });

            this._componentAdd(model, true, SubmitModelStates.IN_PROGRESS);

            return model;
        },

        _componentAdd: function(model, addToPageableItems, state) {
            model.set("state", state);
            if( addToPageableItems ){
                this.pageableItems.addElement(model);
            }
            model.save(state)
                .done(function () {
                    setTimeout(function () {
                        if( model.get("state")===SubmitModelStates.SUCCESSFUL ) {
                            model.set("state", SubmitModelStates.READY);
                        }
                    }, 5000);
                }.bind(this));
        },
        
        displaySubmitView: function () {
            return this.options.isProjectAdmin;
        },

        showHiddenFlag: function (model) {
            var name = AJS.escapeHtml(model.get('name'));
            jiraFlag.showSuccessMsg(null, formatter.I18n.getText("project.page.components.add.hidden.message", name), {
                close: 'auto'
            });
        }
    });

    return SubmitController;
});
