define("jira/projects/components/nocomponentslayoutview", [
    "jira-projects-backbone",
    "jira/projects/components/submitview",
    "jira/projects/components/empty-view",
    "jira/projects/components/templates",
    "jira/projects/libs/marionette"
], function(Backbone, SubmitView, EmptyView, Templates, Marionette) {
    "use strict";

    return Marionette.LayoutView.extend({
        template: Templates.noComponentsLayout,
        regions: {
            noComponents: ".no-components-container",
            submitRegion: ".submit-container"
        },

        onRender: function () {
            this._initializeViews();
        },

        initialize: function(options) {
            this._submitController = options.submitController;
        },

        _initializeViews: function () {
            this.noComponents.show(new EmptyView({
                model: new Backbone.Model({learnMoreUrl: this.options.learnMoreUrl})
            }));

            if (this._submitController.displaySubmitView()) {
                this.submitRegion.show(this._submitController.showView());
            }
        }
    });
});
