define("jira/projects/components/filter-view", [
    "jira/projects/components/templates",
    "jira/projects/components/analytics",
    "jira/projects/libs/marionette",
    "underscore",
    "jira/util/logger"
], function(Templates, Analytics, Marionette, _, logger) {
    "use strict";

    var CLASSES = {
        CONTAINS_OPENED: "component-filter-search-opened",
        STATUS_PRESSED: "component-filter-status-pressed"
    };

    return Marionette.ItemView.extend({
        template: Templates.filter,
        ui: {
            "form": "form",
            "contains": ".text",
            "active": ".component-filter-status-active",
            "archived": ".component-filter-status-archived",
            "quickFilter": ".component-filter-status-text",
            "searchContainer": ".component-filter-search-container"
        },
        events: {
            "submit @ui.form": "formSubmit",
            "input @ui.contains": "inputContains",
            "change @ui.contains": "inputContains",
            "click @ui.active": "clickStatusActive",
            "click @ui.archived": "clickStatusArchived",
            "focus @ui.contains": function() {
                this.ui.searchContainer.addClass(CLASSES.CONTAINS_OPENED);
            },
            "blur @ui.contains": function() {
                if (this._isContainsEmpty()) {
                    this.ui.searchContainer.removeClass(CLASSES.CONTAINS_OPENED);
                }
            }
        },
        initialize: function () {
            Analytics.listenForActionsOnItem(this);
        },
        formSubmit: function formSubmit(e) {
            e.preventDefault();
        },
        inputContains: _.debounce(function inputContains(e) {
            var filter = this.ui.contains.val();
            this.model.set("contains", filter);
            this.trigger("searchItemEvent");
        }, 300),
        _isContainsEmpty: function() {
            return _.isEmpty(this.ui.contains.val());
        },
        clickStatusActive: function (e) {
            e.preventDefault();
            var currentStatus = this.model.get("isActivePressed");
            this.model.set("isActivePressed", !currentStatus);
            this.ui.active.toggleClass(CLASSES.STATUS_PRESSED, !currentStatus);
            logger.trace("project.components.status.changed");
        },
        clickStatusArchived: function (e) {
            e.preventDefault();
            var currentStatus = this.model.get("isArchivedPressed");
            this.model.set("isArchivedPressed", !currentStatus);
            this.ui.archived.toggleClass(CLASSES.STATUS_PRESSED, !currentStatus);
            logger.trace("project.components.status.changed");
        },
        serializeData: function () {
            return {
                contains: this.model.get("contains"),
                isArchivedPressed: this.model.get("isArchivedPressed"),
                isActivePressed: this.model.get("isActivePressed"),
                //showArchived: that.options.isProjectAdmin
            };
        }
    });

});

AJS.namespace("JIRA.Projects.Components.FilterView", null, require("jira/projects/components/filter-view"));
