define('jira/projects/components/filter-model', [
    "jira/projects/abstract-list/filter-model",
    "jira/projects/abstract-model/submit-model-states",
    "jira/util/strings"
], function(ALFilterModel, SubmitModelStates, Strings) {
    "use strict";

    var FilterModel = ALFilterModel.extend({
        filterAttributes: ['contains', 'isActivePressed', 'isArchivedPressed'],
        defaults: {
            contains: "",
            isActivePressed: false,
            isArchivedPressed: false
        },
        initialize: function initialize(options) {
            ALFilterModel.prototype.initialize.call(this, options);

            this.on("change:contains change:isArchivedPressed change:isActivePressed", this.filterCollection);
            this.on("change:contains change:isArchivedPressed change:isActivePressed", this.navigate);
        },

        _containsValue: function() {
            return (this.get("contains") || "").toLowerCase();
        },

        emptyContainsField: function () {
            this.set('contains', '');
        },

        elementMatchFilter: function(element) {
            return this.elementMatchesSerchQuery(element) && ( this.modelMatchesActiveFilter(element) || this.modelMatchesArchivedFilter(element) )
        },

        elementMatchesSerchQuery : function(element) {
            var contains = this._containsValue();
            return (
                (element.get("name") && Strings.contains(element.get("name").toLowerCase(), contains)) ||
                (element.get("description") && Strings.contains(element.get("description").toLowerCase(), contains)) ||
                (element.get("leadUserDisplayName") && Strings.contains(element.get("leadUserDisplayName"), contains)) ||
                (element.get("state") === SubmitModelStates.IN_PROGRESS) ||
                (element.get("state") === SubmitModelStates.IN_PROGRESS_ERROR)
            );
        },

        modelMatchesActiveFilter: function(model){
            var isActivePressed = this.get('isActivePressed');
            var archived = model.get('archived');
            return isActivePressed? !archived : archived;
        },

        modelMatchesArchivedFilter: function(model){
            var isArchivedPressed = this.get('isArchivedPressed');
            var archived = model.get('archived');
            return isArchivedPressed? archived : !archived;
        },

        filterActive: function(collection, isActivePressed){
            if(!isActivePressed){
                return collection;
            }
            return collection.filter(this.modelMatchesActiveFilter.bind(this));
        },

        filterArchived: function(collection, isArchivedPressed){
            if(!isArchivedPressed){
                return collection;
            }
            return collection.filter(this.modelMatchesArchivedFilter.bind(this));
        },

        filterCollection: function filterCollection() {
            var filtered = this.pageableCollection.originalCollection.models;
            var isActivePressed = this.get('isActivePressed');
            var isArchivedPressed = this.get('isArchivedPressed');

            if (this._containsValue() !== "") {
                filtered = filtered.filter(this.elementMatchesSerchQuery.bind(this));
            }

            if( (isActivePressed && isArchivedPressed) || (!isActivePressed && !isArchivedPressed) ){
                return this.pageableCollection.resetFilter(filtered);
            }

            filtered = this.filterActive(filtered, isActivePressed);
            filtered = this.filterArchived(filtered, isArchivedPressed);

            this.pageableCollection.resetFilter(filtered);
        }
    });

    return FilterModel;
});
