define("jira/projects/components/app", [
    "jira/projects/abstract-list/router",
    "jira/projects/abstract-list/navigation-utils",
    "jira-projects-backbone",
    "jira/projects/components/searchlayoutview",
    "jira/projects/components/nocomponentslayoutview",
    "jira/projects/components/pageablecomponentscollection",
    "jira/projects/components/submitcontroller",
    "jira/projects/libs/marionette",
    "jquery",
    "wrm/require",
    "wrm/data",
    "jira/projects/components/filter-model"
], function(
    ALRouter,
    NavigationUtils,
    Backbone,
    SearchLayoutView,
    NoComponentsLayoutView,
    PageableComponentsCollection,
    SubmitController,
    Marionette,
    $,
    wrmRequire,
    WRMData,
    FilterModel
) {
    "use strict";

    var App = new Marionette.Application();

    App.on("start", function(options) {
        var $el = options.container;
        var project = WRMData.claim("com.atlassian.jira.projects.page.components:project");
        var projectId = WRMData.claim("com.atlassian.jira.projects.page.components:projectId");
        var isProjectAdmin = WRMData.claim("com.atlassian.jira.projects.page.components:projectAdmin");
        var data = WRMData.claim("com.atlassian.jira.projects.page.components:components");
        var componentsLearnMoreUrl = WRMData.claim("com.atlassian.jira.projects.page.components:learnMoreUrl");
        var assigneeSelectParams = WRMData.claim("com.atlassian.jira.projects.page.components:assigneeSelectParams");
        var leadDisplayable = assigneeSelectParams.leadDisplayableName;
        var isDefaultAssigneeProjectLead = assigneeSelectParams.isDefaultAssigneeProjectLead;

        App.pageableItems = new PageableComponentsCollection(null, {
            data: data
        });

        App.filter = new FilterModel({
            pageableCollection: App.pageableItems,
            contains: ""
        });
        App.filter.filterCollection();
        App.pageableItems.filter = App.filter;

        App.router = new ALRouter();
        App.router.on("route:any", function() {
            var contains = NavigationUtils.getQueryStringParam("contains", true) || "";
            var isArchivedPressed = NavigationUtils.getQueryStringParam("isArchivedPressed", true) || false;
            var isActivePressed = NavigationUtils.getQueryStringParam("isActivePressed", true) || false;

            App.filter.set("contains", contains, {silent: true});
            App.filter.set("isArchivedPressed", isArchivedPressed, {silent: true});
            App.filter.set("isActivePressed", isActivePressed, {silent: true});
            App.filter.filterCollection();
            App.mainRegion.currentView.trigger('filterChanged');
        });
        App.submitController = new SubmitController({
            pageableItems: App.pageableItems,
            project: project,
            displayableProjectLead: leadDisplayable,
            isDefaultAssigneeProjectLead: isDefaultAssigneeProjectLead,
            isProjectAdmin: isProjectAdmin
        });

        function onNavigate() {
            App.trigger("navigate");
        }

        App.filter.on("navigate", onNavigate);
        App.router.on("route:any", onNavigate);

        App.addRegions({
            mainRegion: new Marionette.Region({el: $el})
        });
        App.pageableItems.on('update', function () {
            this.trigger("componentsLoadedEvent", {
                componentsTotal: App.pageableItems.elementsLeft().elementsTotal
            });

            var searchLayoutView = new SearchLayoutView({
                submitController: App.submitController,
                pageableItems: App.pageableItems,
                filter: App.filter,
                learnMoreUrl: componentsLearnMoreUrl
            });
            App.mainRegion.show(searchLayoutView);
            searchLayoutView.on("navigate", onNavigate);
        });
        App.pageableItems.trigger('update');


        if (Backbone.history && Backbone.History && !Backbone.History.started) {
            Backbone.history.start({
                root: NavigationUtils.getBackboneHistoryRoot(),
                pushState: NavigationUtils.pushStateSupported
            });
        }

        App.requireProjectConfig = wrmRequire([
            "wr!com.atlassian.jira.jira-project-config-plugin:project-config-utilities",
            "wr!com.atlassian.jira.jira-project-config-plugin:project-config-component-views"
        ]);

        // required by project config resources
        $('<meta>').attr("name", "projectKey").attr("content", project).appendTo('head');
        $('<meta>').attr("name", "projectId").attr("content", projectId).appendTo('head');
    });

    return App;
});
