/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.util;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebPanelRenderer {
    private final DynamicWebInterfaceManager webInterfaceManager;
    private static final Logger log = LoggerFactory.getLogger(WebPanelRenderer.class);

    @Autowired
    public WebPanelRenderer(@ComponentImport DynamicWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public boolean renderWebPanels(Writer out, String panelLocation, Map<String, Object> context) {
        try {
            List webPanelDescriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors(panelLocation, context);
            if (webPanelDescriptors.isEmpty()) {
                return false;
            }
            for (WebPanelModuleDescriptor webPanelDescriptor : webPanelDescriptors) {
                try {
                    ((WebPanel)webPanelDescriptor.getModule()).writeHtml(out, context);
                }
                catch (RuntimeException e) {
                    log.warn("Cannot render WebPanel with key '{}'", (Object)webPanelDescriptor.getCompleteKey(), (Object)e);
                }
                catch (IOException e) {
                    log.warn("Cannot write WebPanel with key '{}' to the output", (Object)webPanelDescriptor.getCompleteKey(), (Object)e);
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            log.warn("Cannot fetch WebPanels for location '{}'", (Object)panelLocation, (Object)e);
            return false;
        }
    }

    public Option<String> renderWebPanels(String panelLocation, Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        if (this.renderWebPanels(writer, panelLocation, context)) {
            return Option.some((Object)writer.toString());
        }
        return Option.none();
    }
}

