/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.util;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Map;

public class Preconditions {
    public static Project checkProjectNotNull(String projectKey, ProjectService.GetProjectResult result) {
        if (result.getProject() != null) {
            return result.getProject();
        }
        ErrorCollection errorCollection = result.getErrorCollection();
        StringBuilder message = new StringBuilder();
        message.append("Project with key '").append(projectKey).append("' should have been resolved and accessible, but was not found, because:");
        for (String string : errorCollection.getErrorMessages()) {
            message.append("\n    ").append(string);
        }
        for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
            message.append("\n    ").append((String)entry.getKey()).append(": ").append((String)entry.getValue());
        }
        throw new NullPointerException(message.toString());
    }
}

