/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PageIdHasher {
    private static final List<String> prefixes = ImmutableList.of((Object)"NONE", (Object)"com.atlassian.jira.jira-projects-plugin:project-issue-search-link", (Object)"com.atlassian.jira.jira-projects-plugin:components-page", (Object)"com.atlassian.jira.jira-projects-plugin:reports-panel", (Object)"com.atlassian.jira.jira-projects-plugin:summary-panel", (Object)"com.atlassian.jira.jira-projects-plugin:summary-page", (Object)"com.atlassian.jira.jira-projects-plugin:components-page", (Object)"com.atlassian.jira.jira-projects-plugin:release-page", (Object)"com.atlassian.jira.jira-projects-plugin:release-sidebar-version-", (Object)"com.atlassian.jira.jira-projects-plugin:report-page", (Object)"com.pyxis.greenhopper.jira:global-sidebar-report", (Object)"com.pyxis.greenhopper.jira:global-sidebar-plan-scrum", (Object[])new String[]{"com.pyxis.greenhopper.jira:global-sidebar-work-scrum", "com.pyxis.greenhopper.jira:global-sidebar-work-kanban", "com.pyxis.greenhopper.jira:project-sidebar-plan-scrum", "com.pyxis.greenhopper.jira:project-sidebar-work-scrum", "com.pyxis.greenhopper.jira:project-sidebar-work-kanban", "com.atlassian.jira.jira-projects-issue-navigator:embedded-issue-navigator-link"});

    public HashedId generateId(String id) {
        final String pageId = StringUtils.isNotBlank((CharSequence)id) ? id : "NONE";
        String prefix = (String)Iterables.find(prefixes, (Predicate)new Predicate<String>(){

            public boolean apply(String idPrefix) {
                return pageId.startsWith(idPrefix);
            }
        }, (Object)"");
        String suffix = pageId.substring(prefix.length());
        String hashedId = prefix + (suffix.length() > 0 ? String.valueOf(suffix.hashCode()) : "");
        return new HashedId(prefix, hashedId);
    }

    public static class HashedId
    extends PageIdHasher {
        private final String prefix;
        private final String id;

        public HashedId(String prefix, String id) {
            this.prefix = prefix;
            this.id = id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getId() {
            return this.id;
        }
    }
}

