/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.subnavigator;

import com.atlassian.jira.projects.api.subnavigator.SubNavigatorSettingService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class SubNavigatorSettingServiceImpl
implements SubNavigatorSettingService {
    private static final String SUB_NAV_PINNED_PREFIX = "jira.projects.sub.nav.";
    private static final String SUB_NAV_PINNED_SUFFIX = ".pinned";
    private final UserPropertyManager userPropertyManager;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public SubNavigatorSettingServiceImpl(@ComponentImport UserPropertyManager userPropertyManager, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.userPropertyManager = userPropertyManager;
        this.authenticationContext = authenticationContext;
    }

    public Option<Boolean> isSubNavigationPinned(String subNavId) {
        if (this.authenticationContext.isLoggedInUser()) {
            String pinnedKey;
            PropertySet propertySet = this.userPropertyManager.getPropertySet(this.authenticationContext.getUser());
            if (propertySet.exists(pinnedKey = this.getPropertyKey(subNavId))) {
                return Option.option((Object)propertySet.getBoolean(pinnedKey));
            }
            return Option.none();
        }
        return Option.none();
    }

    public void pinSubNavigator(String subNavId) {
        if (this.authenticationContext.isLoggedInUser()) {
            PropertySet propertySet = this.userPropertyManager.getPropertySet(this.authenticationContext.getUser());
            String pinnedKey = this.getPropertyKey(subNavId);
            propertySet.setBoolean(pinnedKey, true);
        }
    }

    public void unpinSubNavigator(String subNavId) {
        if (this.authenticationContext.isLoggedInUser()) {
            PropertySet propertySet = this.userPropertyManager.getPropertySet(this.authenticationContext.getUser());
            String pinnedKey = this.getPropertyKey(subNavId);
            propertySet.setBoolean(pinnedKey, false);
        }
    }

    public void deleteSubNavigatorPinStatus(String subNavId) {
        if (this.authenticationContext.isLoggedInUser()) {
            PropertySet propertySet = this.userPropertyManager.getPropertySet(this.authenticationContext.getUser());
            String pinnedKey = this.getPropertyKey(subNavId);
            propertySet.remove(pinnedKey);
        }
    }

    private String getPropertyKey(String subNavId) {
        return SUB_NAV_PINNED_PREFIX + subNavId + SUB_NAV_PINNED_SUFFIX;
    }
}

