/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.navigation;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SidebarNavigationService {
    private final ProjectContextPopulator contextPopulator;
    private final NavigationItemService navigationItemService;

    @Autowired
    public SidebarNavigationService(ProjectContextPopulator contextPopulator, NavigationItemService navigationItemService) {
        this.contextPopulator = contextPopulator;
        this.navigationItemService = navigationItemService;
    }

    public Optional<NavigationItem> getNavigationItemById(String id, Project project) {
        if (id == null) {
            return Optional.empty();
        }
        Map context = this.contextPopulator.populateWithProject(project);
        ArrayDeque<NavigationItem> navigationItemQueue = new ArrayDeque<NavigationItem>(this.getSidebarNavigationItems(context));
        while (!navigationItemQueue.isEmpty()) {
            NavigationItem navItem = (NavigationItem)navigationItemQueue.remove();
            if (id.equals(navItem.getId())) {
                return Optional.of(navItem);
            }
            navigationItemQueue.addAll(navItem.getChildren());
        }
        return Optional.empty();
    }

    public List<NavigationItem> getSidebarNavigationItems(Map<String, Object> context) {
        ArrayList<NavigationItem> items = new ArrayList<NavigationItem>();
        items.addAll(this.navigationItemService.getItemsInSection("jira.project.sidebar.navigation", context));
        items.addAll(this.navigationItemService.getItemsInSection("jira.project.sidebar.plugins.navigation", context));
        items.addAll(this.navigationItemService.getItemsInSection("jira.project.sidebar.legacy.tabs.navigation", context));
        return items;
    }
}

