/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.lastvisited;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.sidebar.lastvisited.LastVisitedItemUrlProvider;
import com.atlassian.jira.projects.sidebar.lastvisited.LastVisitedNavigationItemHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LastVisitedItemInProjectService {
    static final String PROPERTY_PREFIX = "last-visited-item.";
    private final UserPropertyManager userPropertyManager;
    private final JiraAuthenticationContext authenticationContext;
    private final LastVisitedNavigationItemHelper lastVisitedNavigationItemHelper;
    private final LastVisitedItemUrlProvider lastVisitedItemUrlProvider;

    @Autowired
    public LastVisitedItemInProjectService(@ComponentImport UserPropertyManager userPropertyManager, @ComponentImport JiraAuthenticationContext authenticationContext, LastVisitedNavigationItemHelper lastVisitedNavigationItemHelper, LastVisitedItemUrlProvider lastVisitedItemUrlProvider) {
        this.userPropertyManager = userPropertyManager;
        this.authenticationContext = authenticationContext;
        this.lastVisitedNavigationItemHelper = lastVisitedNavigationItemHelper;
        this.lastVisitedItemUrlProvider = lastVisitedItemUrlProvider;
    }

    public Optional<ErrorCollection> setLastVisitedItemIdForProject(Project project, String lastVisitedItemId) {
        if (!this.isValid(lastVisitedItemId, project)) {
            return Optional.of(new SimpleErrorCollection());
        }
        if (this.authenticationContext.isLoggedInUser()) {
            String lastVisitedItemForProject = this.propertyKeyFor(project);
            PropertySet propertySetForUser = this.userPropertyManager.getPropertySet(this.authenticationContext.getLoggedInUser());
            propertySetForUser.setString(lastVisitedItemForProject, lastVisitedItemId);
        }
        return Optional.empty();
    }

    private Optional<String> getLastVisitedItemIdForProject(Project project) {
        if (this.authenticationContext.isLoggedInUser()) {
            String lastVisitedItemForProject = this.propertyKeyFor(project);
            PropertySet propertySetForUser = this.userPropertyManager.getPropertySet(this.authenticationContext.getLoggedInUser());
            return Optional.ofNullable(propertySetForUser.getString(lastVisitedItemForProject));
        }
        return Optional.empty();
    }

    private Optional<NavigationItem> getLastVisitedItem(Project project) {
        return this.getLastVisitedItemIdForProject(project).flatMap(lastItemId -> this.lastVisitedNavigationItemHelper.getNavigationItemById((String)lastItemId, project));
    }

    public Optional<String> getLastVisitedItemUrl(Project project) {
        Optional<NavigationItem> lastVisitedNavItemOptional = this.getLastVisitedItem(project);
        return this.lastVisitedItemUrlProvider.getLastVisitedItemUrl(lastVisitedNavItemOptional, project);
    }

    private String propertyKeyFor(Project project) {
        return PROPERTY_PREFIX + project.getId();
    }

    private boolean isValid(String lastVisitedItemId, Project project) {
        return this.lastVisitedNavigationItemHelper.getNavigationItemById(lastVisitedItemId, project).isPresent();
    }
}

