/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.footer;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.footer.SettingsButton;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectAdminLinkService {
    public static final String SETTINGS = "project.sidebar.settings.button.label";
    public static final String PROJECT_CONFIG_PREFIX = "/plugins/servlet/project-config/";
    public static final String PROJECT_CONFIG_DEFAULT_PAGE_LOCATION = "jira.project.config.defaultpage";
    public static final String PROJECT_SETTINGS_LINK_ID = "sidebar-project-settings";
    private final ProjectService projectService;
    private final ProjectContextPopulator contextPopulator;
    private final I18nHelper i18nHelper;
    private DynamicWebInterfaceManager webInterfaceManager;
    private final VelocityRequestContextFactory contextFactory;

    @Autowired
    public ProjectAdminLinkService(ProjectService projectService, ProjectContextPopulator contextPopulator, @ComponentImport I18nHelper i18nHelper, @ComponentImport DynamicWebInterfaceManager webInterfaceManager, @ComponentImport VelocityRequestContextFactory contextFactory) {
        this.projectService = projectService;
        this.contextPopulator = contextPopulator;
        this.i18nHelper = i18nHelper;
        this.webInterfaceManager = webInterfaceManager;
        this.contextFactory = contextFactory;
    }

    public Option<SettingsButton> getLinkForProject(Project project) {
        return this.getLinkForProject(project, "");
    }

    public Option<SettingsButton> getLinkForProject(Project project, String selectedItemId) {
        if (this.projectService.currentUserCanAdministerProject(project.getKey())) {
            String adminUrl = this.getAdminUrl(project);
            String adminText = this.i18nHelper.getText(SETTINGS);
            return SettingsButton.buttonOf((String)adminUrl, (String)adminText, (Boolean)PROJECT_SETTINGS_LINK_ID.equals(selectedItemId));
        }
        return Option.none();
    }

    private String getAdminUrl(Project project) {
        String baseUrl = this.contextFactory.getJiraVelocityRequestContext().getBaseUrl();
        Option<String> urlOverride = this.getProjectConfigUrlOverride(project);
        if (urlOverride.isDefined()) {
            return baseUrl + (String)urlOverride.get();
        }
        return baseUrl + PROJECT_CONFIG_PREFIX + URLEncoder.encodePathSegment(project.getKey());
    }

    private Option<String> getProjectConfigUrlOverride(Project project) {
        Map context = this.contextPopulator.populateWithProject(project);
        final Option defaultPageWebItem = Iterables.first((Iterable)this.webInterfaceManager.getDisplayableWebItems(PROJECT_CONFIG_DEFAULT_PAGE_LOCATION, context));
        if (!defaultPageWebItem.isDefined()) {
            return Option.none();
        }
        return Option.option((Object)SafePluginPointAccess.call((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((WebItem)defaultPageWebItem.get()).getUrl();
            }
        }).getOrNull());
    }
}

