/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.projects.api.sidebar.SidebarRenderer;
import com.atlassian.jira.projects.api.sidebar.footer.SettingsButton;
import com.atlassian.jira.projects.util.WebPanelRenderer;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class SidebarRendererImpl
implements SidebarRenderer {
    private static final String SIDEBAR_PANEL_LOCATION = "com.atlassian.jira.jira-projects-plugin:sidebar-panel";
    private static final String SIDEBAR_INIT_CONTEXT = "com.atlassian.jira.projects.sidebar.init";
    private static final String DARK_FEATURE_BIGPIPE = "com.atlassian.jira.config.BIG_PIPE";
    private final WebPanelRenderer webPanelRenderer;
    private final JiraPageBuilderService jiraPageBuilderService;
    private final FeatureManager featureManager;

    @Autowired
    public SidebarRendererImpl(WebPanelRenderer webPanelRenderer, @ComponentImport JiraPageBuilderService jiraPageBuilderService, @ComponentImport FeatureManager featureManager) {
        this.webPanelRenderer = webPanelRenderer;
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.featureManager = featureManager;
    }

    public String render(Supplier<String> content, Supplier<String> headerContent, Option<SettingsButton> settingsButton) {
        return this.render(false, content, headerContent, settingsButton);
    }

    public String renderHidden() {
        return this.render(true, () -> "", () -> "", (Option<SettingsButton>)Option.none());
    }

    private String render(boolean hidden, Supplier<String> content, Supplier<String> headerContent, Option<SettingsButton> settingsButton) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        String extraClasses = "projects-sidebar";
        if (this.featureManager.isEnabled(DARK_FEATURE_BIGPIPE)) {
            extraClasses = extraClasses + " sidebar-pending";
        }
        params.put((Object)"content", content).put((Object)"headerContent", headerContent).put((Object)"extraClasses", (Object)extraClasses);
        if (settingsButton.isDefined()) {
            SettingsButton button = (SettingsButton)settingsButton.get();
            params.put((Object)"settingsText", (Object)button.getText()).put((Object)"settingsButtonUrl", (Object)button.getHref()).put((Object)"isSettingsButtonSelected", (Object)button.getSelected());
        }
        this.jiraPageBuilderService.assembler().resources().requireContext(SIDEBAR_INIT_CONTEXT);
        return hidden ? "" : (String)this.webPanelRenderer.renderWebPanels(SIDEBAR_PANEL_LOCATION, (Map<String, Object>)params.build()).getOrElse((Object)"");
    }

    public String render(String content, String headerContent, Option<SettingsButton> settingsButton) {
        return this.render(() -> content, () -> headerContent, settingsButton);
    }

    public static class SupplierResolvingContextProvider
    implements ContextProvider {
        public void init(Map<String, String> params) throws PluginParseException {
        }

        public Map<String, Object> getContextMap(Map<String, Object> context) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Supplier)) continue;
                entry.setValue(((Supplier)value).get());
            }
            return ImmutableMap.copyOf(context);
        }
    }
}

