/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts.events;

import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.Set;
import java.util.function.Function;

public enum ProtocolType {
    HTTP(100, "http", "https"),
    FTP(200, "ftp", "ftps"),
    VCS(300, "git", "svn", "cvs", "sourcetree"),
    MAIL(400, "mailto"),
    IM(500, "skype", "callto", "irc", "irc6", "facetime", "hipchat");

    private final Set<String> protocols;
    private final Integer id;
    public static Function<String, Option<ProtocolType>> FROM_PROTOCOL_STRING;
    public static Function<ProtocolType, Integer> TO_ID;

    private ProtocolType(Integer id, String ... protocols) {
        this.id = id;
        this.protocols = ImmutableSet.copyOf((Object[])protocols);
    }

    public Set<String> getProtocols() {
        return this.protocols;
    }

    public Integer getId() {
        return this.id;
    }

    static {
        FROM_PROTOCOL_STRING = new Function<String, Option<ProtocolType>>(){

            @Override
            public Option<ProtocolType> apply(String input) {
                for (ProtocolType type : ProtocolType.values()) {
                    if (!type.getProtocols().contains(input.toLowerCase())) continue;
                    return Option.some((Object)((Object)type));
                }
                return Option.none();
            }
        };
        TO_ID = new Function<ProtocolType, Integer>(){

            @Override
            public Integer apply(ProtocolType input) {
                return input.getId();
            }
        };
    }
}

