/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts;

import com.atlassian.jira.projects.shortcuts.MutableProjectShortcut;
import com.atlassian.jira.projects.shortcuts.QMutableProjectShortcut;
import com.atlassian.jira.projects.shortcuts.ShortcutsStore;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultShortcutsStore
implements ShortcutsStore {
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(DefaultShortcutsStore.class);

    @Autowired
    public DefaultShortcutsStore(@Nonnull DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public List<MutableProjectShortcut> getShortcuts(@Nonnull Long projectId) {
        Objects.requireNonNull(projectId);
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            QMutableProjectShortcut mutableProjectShortcut = new QMutableProjectShortcut();
            return ((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression[])mutableProjectShortcut.all()).from((Expression)mutableProjectShortcut)).where((Predicate)mutableProjectShortcut.PROJECT_ID.eq((Object)projectId))).orderBy(mutableProjectShortcut.PROJECT_ID.asc())).fetch().stream().map(tuple -> this.buildMutableShortcutFromTuple((Tuple)tuple, mutableProjectShortcut)).collect(Collectors.toList());
        });
    }

    @Override
    public MutableProjectShortcut create(@Nonnull String name, @Nonnull String url, @Nullable String icon, @Nonnull Long projectId) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(url);
        Objects.requireNonNull(projectId);
        Integer id = (Integer)this.databaseAccessor.runInTransaction(connection -> {
            QMutableProjectShortcut mutableProjectShortcut = new QMutableProjectShortcut();
            return (Integer)connection.insert((RelationalPath)mutableProjectShortcut).set((Path)mutableProjectShortcut.NAME, (Object)name).set((Path)mutableProjectShortcut.SHORTCUT_URL, (Object)url).set((Path)mutableProjectShortcut.ICON, (Object)icon).set(mutableProjectShortcut.PROJECT_ID, (Object)projectId).executeWithKey(mutableProjectShortcut.ID);
        });
        if (id != null) {
            log.debug("Successfully created a new record with ID: {} ", (Object)id);
        } else {
            log.debug("Failed to create for project {}", (Object)projectId);
        }
        return id == null ? null : new MutableProjectShortcut(name, url, icon, projectId, id);
    }

    @Override
    public Option<MutableProjectShortcut> update(@Nonnull Integer id, @Nonnull String name, @Nonnull String url, @Nullable String icon) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(name);
        Objects.requireNonNull(url);
        Option<MutableProjectShortcut> mutableProjectShortcutOption = this.getShortcut(id);
        if (mutableProjectShortcutOption.isEmpty()) {
            log.debug("Shortcut ID does not exist. Could not perform update.");
            return Option.none();
        }
        long affectedRows = (Long)this.databaseAccessor.runInTransaction(connection -> {
            QMutableProjectShortcut mutableProjectShortcut = new QMutableProjectShortcut();
            return connection.update((RelationalPath)mutableProjectShortcut).where((Predicate)mutableProjectShortcut.ID.eq((Object)id)).set((Path)mutableProjectShortcut.NAME, (Object)name).set((Path)mutableProjectShortcut.SHORTCUT_URL, (Object)url).set((Path)mutableProjectShortcut.ICON, (Object)icon).execute();
        });
        log.debug("Successfully updated {} rows with ID: {} ", (Object)affectedRows, (Object)id);
        Long projectId = this.getProjectId(id);
        return Option.some((Object)(projectId == null ? null : new MutableProjectShortcut(name, url, icon, projectId, id)));
    }

    @Override
    public Option<MutableProjectShortcut> getShortcut(@Nonnull Integer id) {
        Objects.requireNonNull(id);
        return (Option)this.databaseAccessor.runInTransaction(connection -> {
            QMutableProjectShortcut mutableProjectShortcut = new QMutableProjectShortcut();
            return Option.option(((SQLQuery)((SQLQuery)connection.select((Expression[])mutableProjectShortcut.all()).from((Expression)mutableProjectShortcut)).where((Predicate)mutableProjectShortcut.ID.eq((Object)id))).fetch().stream().map(tuple -> this.buildMutableShortcutFromTuple((Tuple)tuple, mutableProjectShortcut)).findFirst().orElse(null));
        });
    }

    @Override
    public Option<MutableProjectShortcut> delete(@Nonnull Integer id) {
        Objects.requireNonNull(id);
        Option<MutableProjectShortcut> shortcutToDelete = this.getShortcut(id);
        if (!shortcutToDelete.isDefined()) {
            log.debug("Shortcut ID {} does not exist. Could not delete.", (Object)id);
            return shortcutToDelete;
        }
        long affectedRows = (Long)this.databaseAccessor.runInTransaction(connection -> {
            QMutableProjectShortcut mutableProjectShortcut = new QMutableProjectShortcut();
            return connection.delete((RelationalPath)mutableProjectShortcut).where((Predicate)mutableProjectShortcut.ID.eq((Object)id)).execute();
        });
        log.debug("Successfully deleted {} rows with ID: {}", (Object)affectedRows, (Object)id);
        return shortcutToDelete;
    }

    @Nonnull
    private MutableProjectShortcut buildMutableShortcutFromTuple(@Nonnull Tuple tuple, @Nonnull QMutableProjectShortcut mutableProjectShortcut) {
        Objects.requireNonNull(tuple);
        Objects.requireNonNull(mutableProjectShortcut);
        return new MutableProjectShortcut((String)tuple.get((Expression)mutableProjectShortcut.NAME), (String)tuple.get((Expression)mutableProjectShortcut.SHORTCUT_URL), (String)tuple.get((Expression)mutableProjectShortcut.ICON), (Long)tuple.get(mutableProjectShortcut.PROJECT_ID), (Integer)tuple.get(mutableProjectShortcut.ID));
    }

    @Nullable
    private Long getProjectId(@Nonnull Integer id) {
        Objects.requireNonNull(id);
        return (Long)this.databaseAccessor.runInTransaction(connection -> {
            QMutableProjectShortcut mutableProjectShortcut = new QMutableProjectShortcut();
            return ((SQLQuery)((SQLQuery)connection.select(mutableProjectShortcut.PROJECT_ID).from((Expression)mutableProjectShortcut)).where((Predicate)mutableProjectShortcut.ID.eq((Object)id))).fetch().stream().findFirst().orElse(null);
        });
    }
}

