/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.projects.shortcuts.DefaultShortcutsStore;
import com.atlassian.jira.projects.shortcuts.MutableProjectShortcut;
import com.atlassian.jira.projects.shortcuts.ShortcutsStore;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CachingShortcutsStore
implements ShortcutsStore,
InitializingBean,
DisposableBean {
    private final DefaultShortcutsStore delegate;
    private final EventPublisher eventPublisher;
    private final Cache<Long, List<MutableProjectShortcut>> shortcutsCache;

    @Autowired
    public CachingShortcutsStore(DefaultShortcutsStore delegate, @ComponentImport CacheManager cacheManager, @ComponentImport EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.shortcutsCache = cacheManager.getCache(CachingShortcutsStore.class.getCanonicalName(), (CacheLoader)new ShortcutsCacheLoader());
    }

    @Override
    public List<MutableProjectShortcut> getShortcuts(Long projectId) {
        return (List)this.shortcutsCache.get((Object)projectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableProjectShortcut create(String name, String url, String icon, Long projectId) {
        try {
            MutableProjectShortcut mutableProjectShortcut = this.delegate.create(name, url, icon, projectId);
            return mutableProjectShortcut;
        }
        finally {
            this.shortcutsCache.remove((Object)projectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<MutableProjectShortcut> update(Integer id, String name, String url, String icon) {
        Option<MutableProjectShortcut> result = Option.none();
        try {
            result = this.delegate.update(id, name, url, icon);
            this.ensureCacheCleared(result, id);
        }
        catch (Throwable throwable) {
            this.ensureCacheCleared(result, id);
            throw throwable;
        }
        return result;
    }

    @Override
    public Option<MutableProjectShortcut> getShortcut(Integer id) {
        return this.delegate.getShortcut(id);
    }

    @Override
    public Option<MutableProjectShortcut> delete(Integer id) {
        Option<MutableProjectShortcut> result = Option.none();
        try {
            result = this.delegate.delete(id);
        }
        finally {
            this.ensureCacheCleared(result, id);
        }
        return result;
    }

    private void ensureCacheCleared(Option<MutableProjectShortcut> result, Integer id) {
        if (!result.isDefined()) {
            result = this.delegate.getShortcut(id);
        }
        if (result.isDefined()) {
            this.shortcutsCache.remove((Object)((MutableProjectShortcut)result.get()).getProjectId());
        }
    }

    @EventListener
    public void clearCaches(@Nullable ClearCacheEvent event) {
        this.shortcutsCache.removeAll();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    private class ShortcutsCacheLoader
    implements CacheLoader<Long, List<MutableProjectShortcut>> {
        private ShortcutsCacheLoader() {
        }

        @Nonnull
        public List<MutableProjectShortcut> load(@Nonnull Long key) {
            return CachingShortcutsStore.this.delegate.getShortcuts(key);
        }
    }
}

