/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.servlet;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.web.servlet.api.ForwardAuthorizer;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Pair;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ProjectForwardsAuthorizer
implements ForwardAuthorizer {
    private static List<Pair<Pattern, Pattern>> matchPatterns = ImmutableList.builder().add((Object)Pair.pair((Object)Pattern.compile("/browse/[A-Z][A-Z0-9_]+", 2), (Object)Pattern.compile("/projects/[A-Z][A-Z0-9_]+", 2))).add((Object)Pair.pair((Object)Pattern.compile("/projects/[A-Z][A-Z0-9_]+", 2), (Object)Pattern.compile("/projects/[A-Z][A-Z0-9_]+", 2))).add((Object)Pair.pair((Object)Pattern.compile("/plugins/servlet/projects/[A-Z][A-Za-z0-9_]+", 2), (Object)Pattern.compile("/projects/[A-Z][A-Z0-9_]+/issues", 2))).add((Object)Pair.pair((Object)Pattern.compile("/plugins/servlet/projects/[A-Z][A-Za-z0-9_]+", 2), (Object)Pattern.compile("/projects/[A-Z][A-Z0-9_]+", 2))).add((Object)Pair.pair((Object)Pattern.compile("/browse/[a-z][a-z0-9_]+-[0-9]+", 2), (Object)Pattern.compile("/browse/[a-z][a-z0-9_]+-[0-9]+", 2))).build();

    public Optional<Boolean> authorizeForward(HttpServletRequest source, URI target) {
        String servletPath = ProjectForwardsAuthorizer.extractFullPath(source);
        String targetPath = target.getPath();
        boolean requestMatches = matchPatterns.stream().anyMatch(patternPatternPair -> ((Pattern)patternPatternPair.left()).matcher(servletPath).matches() && ((Pattern)patternPatternPair.right()).matcher(targetPath).matches());
        return requestMatches ? Optional.of(true) : Optional.empty();
    }

    private static String extractFullPath(@Nonnull HttpServletRequest request) {
        return Stream.of(Optional.ofNullable(request.getServletPath()), Optional.ofNullable(request.getPathInfo())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining());
    }
}

