/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status;

import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class StatusCountToCategoryAggregator {
    private final StatusCategoryManager statusCategoryManager;

    @Autowired
    public StatusCountToCategoryAggregator(@ComponentImport StatusCategoryManager statusCategoryManager) {
        this.statusCategoryManager = (StatusCategoryManager)Preconditions.checkNotNull((Object)statusCategoryManager);
    }

    public Map<StatusCategory, Long> getIssueCountPerStatusCategory(Map<Status, Long> statusesMappedToIssueCounts) {
        Map<StatusCategory, Long> allStatusCategoriesMappedToIssueCounts = this.allStatusCategoriesMappedToACountOfZero();
        allStatusCategoriesMappedToIssueCounts.putAll(this.toIssueCountsByStatusCategory(statusesMappedToIssueCounts));
        return allStatusCategoriesMappedToIssueCounts;
    }

    private Map<StatusCategory, Long> allStatusCategoriesMappedToACountOfZero() {
        List statusCategories = this.statusCategoryManager.getStatusCategories();
        return statusCategories.stream().collect(Collectors.toMap(Function.identity(), statusCategory -> 0L));
    }

    private Map<StatusCategory, Long> toIssueCountsByStatusCategory(Map<Status, Long> statusesMappedToIssueCounts) {
        return statusesMappedToIssueCounts.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Status)entry.getKey()).getStatusCategory(), Collectors.summingLong(Map.Entry::getValue)));
    }
}

