/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status;

import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusCount;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

public class StatusCategoryCount {
    private final StatusCategory statusCategory;
    private final String translatedName;
    private final long count;
    private final long roughPercentage;
    private final Collection<StatusCount> statuses;

    public StatusCategoryCount(@Nonnull StatusCategory statusCategory, @Nonnull String name, long count, long roughPercentage, @Nonnull Collection<StatusCount> statuses) {
        this.statusCategory = (StatusCategory)Preconditions.checkNotNull((Object)statusCategory, (Object)"statusCategory");
        this.translatedName = (String)Preconditions.checkNotNull((Object)name, (Object)"translatedName");
        this.count = count;
        this.roughPercentage = roughPercentage;
        this.statuses = statuses != null ? statuses : Collections.emptyList();
    }

    public String getName() {
        return this.translatedName;
    }

    public String getColor() {
        return this.statusCategory.getColorName();
    }

    public String getKey() {
        return this.statusCategory.getKey();
    }

    public long getCount() {
        return this.count;
    }

    public long getRoughPercentage() {
        return this.roughPercentage;
    }

    public Collection<StatusCount> getStatuses() {
        return this.statuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusCategoryCount that = (StatusCategoryCount)o;
        if (this.count != that.count) {
            return false;
        }
        if (this.roughPercentage != that.roughPercentage) {
            return false;
        }
        if (!this.statusCategory.equals(that.statusCategory)) {
            return false;
        }
        if (!this.translatedName.equals(that.translatedName)) {
            return false;
        }
        return this.statuses.equals(that.getStatuses());
    }

    public int hashCode() {
        int result = this.statusCategory.hashCode();
        result = 31 * result + this.translatedName.hashCode();
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (int)(this.roughPercentage ^ this.roughPercentage >>> 32);
        return result;
    }

    public String toString() {
        return "StatusCategoryCount{statusCategory=" + this.statusCategory + ", translatedName='" + this.translatedName + '\'' + ", count=" + this.count + ", roughPercentage=" + this.roughPercentage + '}';
    }
}

