/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.assignee;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.DataRequest;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.IssueCountAccessor;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.IssueMapperFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.StatisticAccessorBeanFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.assignee.AssigneeCount;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class AssigneeCountService {
    private final IssueCountAccessor issueCountAccessor;
    private final IssueMapperFactory<ApplicationUser> mapperFactory;
    private final StatisticAccessorBeanFactory beanFactory;

    @Autowired
    public AssigneeCountService(IssueCountAccessor issueCountAccessor, IssueMapperFactory<ApplicationUser> mapperFactory, StatisticAccessorBeanFactory beanFactory) {
        this.issueCountAccessor = issueCountAccessor;
        this.mapperFactory = mapperFactory;
        this.beanFactory = beanFactory;
    }

    public List<AssigneeCount> getAssigneeCounts(DataRequest dataRequest) {
        Map<ApplicationUser, Long> issuesPerAssignee = this.issueCountAccessor.getNonZeroIssueCount(this.beanFactory.createAccessorBeanForUnresolvedIssues(dataRequest), this.mapperFactory.getMapper());
        return (List)issuesPerAssignee.entrySet().stream().map(entry -> new AssigneeCount((ApplicationUser)entry.getKey(), (Long)entry.getValue())).collect(CollectorsUtil.toImmutableList());
    }
}

