/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.DataRequest;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.JqlFactory;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.query.Query;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class StatisticAccessorBeanFactory {
    private final JqlFactory jqlFactory;

    @Autowired
    public StatisticAccessorBeanFactory(JqlFactory jqlFactory) {
        this.jqlFactory = jqlFactory;
    }

    public StatisticAccessorBean createAccessorBeanForAllIssues(DataRequest dataRequest) {
        Query allIssuesJqlQuery = this.jqlFactory.getQueryForAllIssues(dataRequest.getProject());
        return this.createAccessorBean(dataRequest, allIssuesJqlQuery);
    }

    public StatisticAccessorBean createAccessorBeanForUnresolvedIssues(DataRequest dataRequest) {
        Query allUnresolvedJqlQuery = this.jqlFactory.getQueryForAllUnresolvedIssues(dataRequest.getProject());
        return this.createAccessorBean(dataRequest, allUnresolvedJqlQuery);
    }

    private StatisticAccessorBean createAccessorBean(DataRequest dataRequest, Query query) {
        SearchRequest searchRequest = new SearchRequest(query);
        return new StatisticAccessorBean(dataRequest.getUser(), searchRequest);
    }
}

