/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.userformat.UserFormatter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class MostActiveVignetteContextProvider
extends AbstractProjectsPageContextProvider {
    public static final String DISABLE_MOST_ACTIVE_FEATURE_KEY = "com.atlassian.jira.projects.ProjectMostActive.disabled";
    private static final Logger log = LoggerFactory.getLogger(MostActiveVignetteContextProvider.class);
    private static final int MAX_SEARCH_COUNT = 100;
    private static final String AVATAR_FORMATTER = "avatarWithHover";
    private final SearchService searchService;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserFormats userFormats;
    private final DarkFeatureManager darkFeatureManager;
    private static final Function<Issue, String> GET_ASSIGNEE_KEY = new Function<Issue, String>(){

        public String apply(Issue input) {
            return input.getAssigneeId();
        }
    };
    private static final Predicate<Issue> ISSUE_ASSIGNED = new Predicate<Issue>(){

        public boolean apply(Issue input) {
            return input.getAssigneeId() != null;
        }
    };
    public static final Function<Map.Entry<String, Collection<Issue>>, AssigneeAndCount> MAP_ENTRY_TO_COUNT = new Function<Map.Entry<String, Collection<Issue>>, AssigneeAndCount>(){

        public AssigneeAndCount apply(Map.Entry<String, Collection<Issue>> input) {
            return new AssigneeAndCount(input.getKey(), input.getValue().size());
        }
    };

    public MostActiveVignetteContextProvider(@ComponentImport SearchService searchService, @ComponentImport AvatarService avatarService, @ComponentImport UserManager userManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport UserFormats userFormats, @ComponentImport DarkFeatureManager darkFeatureManager) {
        this.searchService = searchService;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userFormats = userFormats;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        return ImmutableMap.of((Object)"mostActive", this.getMostActive(project));
    }

    private List<String> getMostActive(Project project) {
        if (this.darkFeatureManager.isFeatureEnabledForCurrentUser(DISABLE_MOST_ACTIVE_FEATURE_KEY)) {
            return ImmutableList.of();
        }
        Iterable onlyAssignedIssues = Iterables.filter(this.getRecentlyModifiedIssues(project), ISSUE_ASSIGNED);
        ImmutableMap assigneeToIssues = Multimaps.index((Iterable)onlyAssignedIssues, GET_ASSIGNEE_KEY).asMap();
        ImmutableSortedSet assigneeAndCounts = ImmutableSortedSet.copyOf((Iterable)Iterables.transform((Iterable)assigneeToIssues.entrySet(), MAP_ENTRY_TO_COUNT));
        final UserFormatter userFormatter = this.userFormats.formatter(AVATAR_FORMATTER);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.limit((Iterable)assigneeAndCounts, (int)5), (Function)new Function<AssigneeAndCount, String>(){

            public String apply(AssigneeAndCount input) {
                ApplicationUser user = MostActiveVignetteContextProvider.this.userManager.getUserByKey(input.userKey);
                URI avatarURL = MostActiveVignetteContextProvider.this.avatarService.getAvatarURL(MostActiveVignetteContextProvider.this.jiraAuthenticationContext.getUser(), user, Avatar.Size.NORMAL);
                return userFormatter.formatUserkey(input.userKey, "mostactive", (Map)ImmutableMap.of((Object)"avatarSize", (Object)Avatar.Size.NORMAL.getParam(), (Object)"avatarURL", (Object)avatarURL.toString()));
            }
        }));
    }

    private List<Issue> getRecentlyModifiedIssues(Project project) {
        Query recentlyUpdatedIssuesQuery = JqlQueryBuilder.newBuilder().where().project(new Long[]{project.getId()}).and().assignee().notEqEmpty().and().updatedAfter("-1w").endWhere().orderBy().updatedDate(SortOrder.DESC).buildQuery();
        try {
            return this.searchService.search(this.jiraAuthenticationContext.getLoggedInUser(), recentlyUpdatedIssuesQuery, new PagerFilter(100)).getResults();
        }
        catch (SearchException e) {
            log.warn("Cannot execute query '{}'", (Object)recentlyUpdatedIssuesQuery, (Object)e);
            return ImmutableList.of();
        }
    }

    private static class AssigneeAndCount
    implements Comparable<AssigneeAndCount> {
        private final String userKey;
        private final Integer count;

        private AssigneeAndCount(String assigneeKey, Integer count) {
            this.userKey = assigneeKey;
            this.count = count;
        }

        @Override
        public int compareTo(AssigneeAndCount o) {
            int countCompare = o.count.compareTo(this.count);
            if (countCompare != 0) {
                return countCompare;
            }
            return this.userKey.compareTo(o.userKey);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssigneeAndCount that = (AssigneeAndCount)o;
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            int result = this.userKey.hashCode();
            result = 31 * result + this.count.hashCode();
            return result;
        }
    }
}

