/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.report;

import com.atlassian.jira.plugin.report.ReportCategory;
import com.atlassian.jira.plugin.report.ReportCategoryImpl;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.page.report.ReportCategoryView;
import com.atlassian.jira.projects.page.report.ReportService;
import com.atlassian.jira.projects.page.report.ReportView;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Options;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Scanned
public class ReportPageContextProvider
extends AbstractProjectsPageContextProvider {
    private static final String REPORTS_PAGE_CONTEXT = "com.atlassian.jira.project.reports.page";
    private final ReportService reportService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PageBuilderService pageBuilderService;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;

    public ReportPageContextProvider(ReportService reportService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport JiraPageBuilderService pageBuilderService, @ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller) {
        this.reportService = reportService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.pageBuilderService = pageBuilderService;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        Stream.of(REPORTS_PAGE_CONTEXT, "jira.project.sidebar").forEach(ctx -> this.pageBuilderService.assembler().resources().requireContext(ctx));
        List<ReportCategoryView> reportCategoryViews = this.groupReports(originalContext);
        ReportCategoryView agileReportCategoryViewOption = this.getAgileReportCategoryView(reportCategoryViews);
        this.pageBuilderService.assembler().data().requireData("agile-reports", this.asJsonable(agileReportCategoryViewOption));
        return ImmutableMap.of((Object)"reports", reportCategoryViews);
    }

    private ReportCategoryView getAgileReportCategoryView(List<ReportCategoryView> reportCategoryViews) {
        return (ReportCategoryView)Iterables.find(reportCategoryViews, (Predicate)new Predicate<ReportCategoryView>(){

            public boolean apply(@Nullable ReportCategoryView reportCategoryView) {
                return reportCategoryView.getKey().equals(ReportCategoryImpl.AGILE.getKey());
            }
        });
    }

    private Jsonable asJsonable(ReportCategoryView agileReportCategoryViewOption) {
        final List<ReportView> reports = agileReportCategoryViewOption.getReports();
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                writer.append(ReportPageContextProvider.this.jaxbJsonMarshaller.marshal((Object)(reports == null ? Collections.emptyList() : reports)));
            }
        };
    }

    private List<ReportCategoryView> groupReports(Map<String, Object> context) {
        ImmutableList orderedCategories = ImmutableList.of((Object)ReportCategoryImpl.AGILE, (Object)ReportCategoryImpl.ISSUE_ANALYSIS, (Object)ReportCategoryImpl.FORECAST_MANAGEMENT, (Object)ReportCategoryImpl.OTHER);
        Iterable orderedReportViews = Options.flatten((Iterable)Iterables.transform(this.reportService.getReports(context), this.toReportView(context)));
        ImmutableListMultimap reportByCategory = Multimaps.index((Iterable)orderedReportViews, ReportPageContextProvider.getCategoryKey());
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)orderedCategories, this.toReportCategoryView((ImmutableListMultimap<String, ReportView>)reportByCategory)));
    }

    private Function<ReportCategory, ReportCategoryView> toReportCategoryView(final ImmutableListMultimap<String, ReportView> reportByCategory) {
        return new Function<ReportCategory, ReportCategoryView>(){

            public ReportCategoryView apply(ReportCategory input) {
                return new ReportCategoryView(ReportPageContextProvider.this.jiraAuthenticationContext.getI18nHelper().getText(input.getI18nKey()), input.getKey(), (List<ReportView>)reportByCategory.get((Object)input.getKey()));
            }
        };
    }

    private static Function<ReportView, String> getCategoryKey() {
        return new Function<ReportView, String>(){

            public String apply(ReportView input) {
                return input.getCategoryKey();
            }
        };
    }

    private Function<ReportModuleDescriptor, Option<ReportView>> toReportView(final Map<String, Object> context) {
        return new Function<ReportModuleDescriptor, Option<ReportView>>(){

            public Option<ReportView> apply(ReportModuleDescriptor input) {
                Option url = input.getUrl(context);
                if (url.isDefined()) {
                    return Option.some((Object)new ReportView(input.getLabel(), (String)url.get(), input.getDescription(), input.getThumbnailCssClass(), input.getCompleteKey(), input.getCategory().getKey()));
                }
                return Option.none();
            }
        };
    }
}

